/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Peaklist;
import fr.proline.core.orm.msi.SearchSetting;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="msi_search")
public class MsiSearch
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private Timestamp date;
    @Column(name="queries_count")
    private Integer queriesCount;
    @Column(name="result_file_name")
    private String resultFileName;
    @Column(name="result_file_directory")
    private String resultFileDirectory;
    @Column(name="searched_sequences_count")
    private Integer searchedSequencesCount;
    @Column(name="job_number")
    private Integer jobNumber;
    @Column(name="serialized_properties")
    private String serializedProperties;
    private String title;
    @Column(name="user_email")
    private String userEmail;
    @Column(name="user_name")
    private String userName;
    @ManyToOne
    @JoinColumn(name="peaklist_id")
    private Peaklist peaklist;
    @ManyToOne
    @JoinColumn(name="search_settings_id")
    private SearchSetting searchSetting;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="msi_search_object_tree_map", joinColumns={@JoinColumn(name="msi_search_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public Timestamp getDate() {
        Timestamp result = null;
        if (this.date != null) {
            result = (Timestamp)this.date.clone();
        }
        return result;
    }

    public void setDate(Timestamp pDate) {
        this.date = pDate == null ? null : (Timestamp)pDate.clone();
    }

    public Integer getQueriesCount() {
        return this.queriesCount;
    }

    public void setQueriesCount(Integer queriesCount) {
        this.queriesCount = queriesCount;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public String getResultFileDirectory() {
        return this.resultFileDirectory;
    }

    public void setResultFileDirectory(String resultFileDirectory) {
        this.resultFileDirectory = resultFileDirectory;
    }

    public Integer getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(Integer jobNumber) {
        this.jobNumber = jobNumber;
    }

    public Integer getSearchedSequencesCount() {
        return this.searchedSequencesCount;
    }

    public void setSearchedSequencesCount(Integer searchedSequencesCount) {
        this.searchedSequencesCount = searchedSequencesCount;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Peaklist getPeaklist() {
        return this.peaklist;
    }

    public void setPeaklist(Peaklist peaklist) {
        this.peaklist = peaklist;
    }

    public SearchSetting getSearchSetting() {
        return this.searchSetting;
    }

    public void setSearchSetting(SearchSetting searchSetting) {
        this.searchSetting = searchSetting;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.getId()).append("title", (Object)this.getTitle()).append("job", (Object)this.getJobNumber()).append("result filename", (Object)this.getResultFileName()).toString();
    }
}

