/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.Fractionation;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.IdentificationDataset;
import fr.proline.core.orm.uds.MasterQuantitationChannel;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.SampleAnalysis;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="data_set")
@Inheritance(strategy=InheritanceType.JOINED)
@NamedQueries(value={@NamedQuery(name="findDatasetByProject", query="Select ds from Dataset ds where ds.project.id =:id"), @NamedQuery(name="findRootDatasetByProject", query="Select ds from Dataset ds where ds.project.id =:id and ds.parentDataset is null"), @NamedQuery(name="findDatasetNamesByProject", query="Select ds.name from Dataset ds where ds.project.id =:id"), @NamedQuery(name="findRootDatasetNamesByProject", query="Select ds.name from Dataset ds where ds.project.id =:id and ds.parentDataset is null"), @NamedQuery(name="findDatasetByNameAndProject", query="Select ds from Dataset ds where ds.project.id =:id and ds.name=:name"), @NamedQuery(name="findRootDatasetByNameAndProject", query="Select ds from Dataset ds where ds.project.id =:id and ds.name=:name and ds.parentDataset is null")})
public class Dataset
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="creation_timestamp")
    private Timestamp creationTimestamp = new Timestamp(new Date().getTime());
    private String description;
    @Column(name="child_count")
    private int childCount;
    private String keywords;
    @Column(name="modification_log")
    private String modificationLog;
    private String name;
    @Enumerated(value=EnumType.STRING)
    private DatasetType type;
    private int number;
    @ManyToOne
    @JoinColumn(name="fractionation_id")
    private Fractionation fractionation;
    @ManyToOne
    @JoinColumn(name="aggregation_id")
    private Aggregation aggregation;
    @ManyToOne
    @JoinColumn(name="project_id")
    private Project project;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @ManyToOne
    @JoinColumn(name="parent_dataset_id")
    private Dataset parentDataset;
    @OneToMany(mappedBy="parentDataset")
    @OrderBy(value="number")
    private List<Dataset> children;
    @Column(name="result_set_id")
    private Long resultSetId;
    @Column(name="result_summary_id")
    private Long resultSummaryId;
    @OneToMany(mappedBy="dataset")
    @OrderBy(value="number")
    private List<BiologicalSample> biologicalSamples;
    @OneToMany(mappedBy="dataset")
    private Set<GroupSetup> groupSetups;
    @OneToMany(mappedBy="dataset")
    @OrderBy(value="number")
    private List<QuantitationChannel> quantitationChannels;
    @ManyToOne
    @JoinColumn(name="quant_method_id")
    private QuantitationMethod method;
    @OneToMany(mappedBy="quantDataset")
    @OrderBy(value="number")
    private List<MasterQuantitationChannel> masterQuantitationChannels;
    @OneToMany(mappedBy="dataset")
    private Set<SampleAnalysis> sampleAnalyses;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="data_set_object_tree_map", joinColumns={@JoinColumn(name="data_set_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;
    @Transient
    private TransientData transientData = null;

    protected Dataset() {
    }

    public Dataset(Project project) {
        this.project = project;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public int getChildrenCount() {
        return this.childCount;
    }

    public void setChildrenCount(int pChildrenCount) {
        this.childCount = pChildrenCount;
    }

    public Timestamp getCreationTimestamp() {
        Timestamp result = null;
        if (this.creationTimestamp != null) {
            result = (Timestamp)this.creationTimestamp.clone();
        }
        return result;
    }

    public void setCreationTimestamp(Timestamp pCreationTimestamp) {
        if (pCreationTimestamp == null) {
            throw new IllegalArgumentException("PCreationTimestamp is null");
        }
        this.creationTimestamp = (Timestamp)pCreationTimestamp.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DatasetType getType() {
        return this.type;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    public Dataset getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(Dataset parentDataset) {
        this.parentDataset = parentDataset;
    }

    public Long getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(Long pResultSetId) {
        this.resultSetId = pResultSetId;
    }

    public Long getResultSummaryId() {
        return this.resultSummaryId;
    }

    public void setResultSummaryId(Long pResultSummaryId) {
        this.resultSummaryId = pResultSummaryId;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getModificationLog() {
        return this.modificationLog;
    }

    public void setModificationLog(String modificationLog) {
        this.modificationLog = modificationLog;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int pNumber) {
        this.number = pNumber;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public List<BiologicalSample> getBiologicalSamples() {
        return this.biologicalSamples;
    }

    public void setBiologicalSamples(List<BiologicalSample> biologicalSamples) {
        this.biologicalSamples = biologicalSamples;
    }

    public Set<GroupSetup> getGroupSetups() {
        return this.groupSetups;
    }

    public void setGroupSetups(Set<GroupSetup> groupSetups) {
        this.groupSetups = groupSetups;
    }

    public List<QuantitationChannel> getQuantitationChannels() {
        return this.quantitationChannels;
    }

    public void setQuantitationChannels(List<QuantitationChannel> quantitationChannels) {
        this.quantitationChannels = quantitationChannels;
    }

    public QuantitationMethod getMethod() {
        return this.method;
    }

    public void setMethod(QuantitationMethod method) {
        this.method = method;
    }

    public List<MasterQuantitationChannel> getMasterQuantitationChannels() {
        return this.masterQuantitationChannels;
    }

    public void setMasterQuantitationChannels(List<MasterQuantitationChannel> masterQuantitationChannels) {
        this.masterQuantitationChannels = masterQuantitationChannels;
    }

    public Set<SampleAnalysis> getSampleReplicates() {
        return this.sampleAnalyses;
    }

    public void setSampleReplicates(Set<SampleAnalysis> sampleAnalyses) {
        this.sampleAnalyses = sampleAnalyses;
    }

    public Fractionation getFractionation() {
        return this.fractionation;
    }

    public void setFractionation(Fractionation fractionation) {
        this.fractionation = fractionation;
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, Long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, (long)objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }

    public List<Dataset> getChildren() {
        return this.children;
    }

    public void setChildren(List<Dataset> children) {
        this.children = children;
    }

    public void addChild(Dataset child) {
        List<Dataset> childrenList = this.getChildren();
        if (childrenList == null) {
            childrenList = new ArrayList<Dataset>(1);
            this.setChildren(childrenList);
        }
        childrenList.add(child);
        child.setNumber(this.childCount);
        ++this.childCount;
        child.setParentDataset(this);
    }

    public void insertChild(Dataset child, int index) {
        List<Dataset> childrenList = this.getChildren();
        if (childrenList == null) {
            childrenList = new ArrayList<Dataset>(1);
            this.setChildren(childrenList);
        }
        childrenList.add(index, child);
        child.setNumber(index);
        ++this.childCount;
        for (int i = index + 1; i < childrenList.size(); ++i) {
            childrenList.get(i).setNumber(i);
        }
        child.setParentDataset(this);
    }

    public void replaceAllChildren(List<Dataset> newChildren) {
        List<Dataset> childrenList = this.getChildren();
        if (childrenList != null) {
            for (Dataset child : childrenList) {
                child.setParentDataset(null);
                child.setNumber(0);
            }
            childrenList.clear();
            this.childCount = 0;
        }
        for (Dataset newChild : newChildren) {
            this.addChild(newChild);
        }
    }

    public Set<IdentificationDataset> getIdentificationDataset() {
        HashSet<IdentificationDataset> idfDS = new HashSet<IdentificationDataset>();
        if ((this.getChildren() == null || this.getChildren().isEmpty()) && this.getType().equals((Object)DatasetType.IDENTIFICATION)) {
            idfDS.add((IdentificationDataset)this);
        }
        for (Dataset ds : this.getChildren()) {
            idfDS.addAll(ds.getIdentificationDataset());
        }
        return idfDS;
    }

    public Set<Dataset> getIdentificationDatasets() {
        HashSet<Dataset> idfDS = new HashSet<Dataset>();
        if ((this.getChildren() == null || this.getChildren().isEmpty()) && this.getType().equals((Object)DatasetType.IDENTIFICATION)) {
            idfDS.add(this);
        }
        for (Dataset ds : this.getChildren()) {
            idfDS.addAll(ds.getIdentificationDatasets());
        }
        return idfDS;
    }

    public TransientData getTransientData() {
        if (this.transientData == null) {
            this.transientData = new TransientData();
        }
        return this.transientData;
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ResultSummary resultSummary = null;
        private ResultSet resultSet = null;

        protected TransientData() {
        }

        public ResultSummary getResultSummary() {
            return this.resultSummary;
        }

        public void setResultSummary(ResultSummary resultSummary) {
            this.resultSummary = resultSummary;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public void setResultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
        }
    }

    public static enum DatasetType {
        IDENTIFICATION,
        QUANTITATION,
        AGGREGATE,
        TRASH,
        QUANTITATION_FOLDER,
        IDENTIFICATION_FOLDER;

    }
}

