/*
 * Decompiled with CFR 0.152.
 */
package pine.internal;

import pine.HtmlHelpers$;
import pine.Node;
import pine.ParseError;
import pine.Reader;
import pine.Tag;
import pine.Text;
import pine.Text$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;

public final class HtmlParser$ {
    public static final HtmlParser$ MODULE$;

    static {
        new HtmlParser$();
    }

    public Tuple2<String, String> parseAttr(Reader reader) {
        String name = this.identifier(reader);
        String value = reader.prefix('=') ? this.parseAttrValue(reader) : "";
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)value);
    }

    public Map<String, String> parseAttrs(Reader reader) {
        return this.f$1(Predef$.MODULE$.Map().empty(), reader);
    }

    public String rest(Reader reader) {
        return new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(reader.rest())).take(20))).append((Object)"[...]").toString();
    }

    public Nothing$ expected(Reader reader, String expected) {
        throw new ParseError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected '", "', found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, this.rest(reader)})));
    }

    public String parseAttrValue(Reader reader) {
        if (reader.prefix('\"')) {
            String str = (String)reader.collect('\"').getOrElse((Function0)new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final Reader reader$1;

                public final Nothing$ apply() {
                    return HtmlParser$.MODULE$.expected(this.reader$1, "\"");
                }
                {
                    this.reader$1 = reader$1;
                }
            });
            return HtmlHelpers$.MODULE$.decodeAttributeValue(str);
        }
        throw this.expected(reader, "\"");
    }

    public String identifier(Reader reader) {
        Some some;
        String string;
        Option<String> option = reader.collectUntil((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$2) {
                return !HtmlHelpers$.MODULE$.identifierCharacter(x$2);
            }
        });
        boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && "".equals(string = (String)(some = (Some)option).x());
        if (bl) {
            throw new ParseError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Identifier expected, found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rest(reader)})));
        }
        if (option instanceof Some) {
            String value;
            Some some2 = (Some)option;
            String string2 = value = (String)some2.x();
            return string2;
        }
        throw new MatchError(option);
    }

    public List<Node> parseChildren(Reader reader, String tagName, boolean xml) {
        List list;
        if (!xml && HtmlHelpers$.MODULE$.VoidElements().contains((Object)tagName)) {
            list = List$.MODULE$.empty();
        } else if (!xml && HtmlHelpers$.MODULE$.CdataElements().contains((Object)tagName)) {
            String result = (String)reader.collect(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"</", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName}))).getOrElse((Function0)new Serializable(reader, tagName){
                public static final long serialVersionUID = 0L;
                private final Reader reader$3;
                private final String tagName$1;

                public final Nothing$ apply() {
                    return HtmlParser$.MODULE$.expected(this.reader$3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"</", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tagName$1})));
                }
                {
                    this.reader$3 = reader$3;
                    this.tagName$1 = tagName$1;
                }
            });
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Text[]{new Text(result)}));
        } else {
            list = this.f$2(List$.MODULE$.empty(), reader, tagName, xml);
        }
        return list;
    }

    public boolean skipComment(Reader reader) {
        boolean bl;
        if (reader.prefix("<!--")) {
            reader.collect("-->").orElse((Function0)new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final Reader reader$4;

                public final Nothing$ apply() {
                    return HtmlParser$.MODULE$.expected(this.reader$4, "-->");
                }
                {
                    this.reader$4 = reader$4;
                }
            });
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void skipDocType(Reader reader) {
        if (reader.prefix("<!DOCTYPE")) {
            reader.collect('>').orElse((Function0)new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final Reader reader$6;

                public final Nothing$ apply() {
                    return HtmlParser$.MODULE$.expected(this.reader$6, ">");
                }
                {
                    this.reader$6 = reader$6;
                }
            });
        }
    }

    public void skipXml(Reader reader) {
        if (reader.prefix("<?xml")) {
            reader.collect('>').orElse((Function0)new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final Reader reader$7;

                public final Nothing$ apply() {
                    return HtmlParser$.MODULE$.expected(this.reader$7, ">");
                }
                {
                    this.reader$7 = reader$7;
                }
            });
        }
    }

    public Option<Text> parseCdata(Reader reader) {
        return reader.prefix("<![CDATA[") ? reader.collect("]]>").map((Function1)Text$.MODULE$).orElse((Function0)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final Reader reader$8;

            public final Nothing$ apply() {
                return HtmlParser$.MODULE$.expected(this.reader$8, "]]>");
            }
            {
                this.reader$8 = reader$8;
            }
        }) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tag<?>> parseTag(Reader reader, boolean xml) {
        None$ none$;
        if (reader.prefix("<")) {
            List<Node> list;
            String tagName = this.identifier(reader);
            reader.skip((Function1<Object, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$3) {
                    return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$3));
                }
            });
            Map<String, String> tagAttrs = this.parseAttrs(reader);
            if (reader.prefix("/>")) {
                list = List$.MODULE$.empty();
            } else {
                if (!reader.prefix(">")) throw this.expected(reader, "/>");
                list = this.parseChildren(reader, tagName, xml);
            }
            List<Node> tagChildren = list;
            none$ = new Some(new Tag(tagName, tagAttrs, tagChildren));
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Text> parseText(Reader reader, boolean xml) {
        String text = (String)reader.collectUntil('<').getOrElse((Function0)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final Reader reader$9;

            public final String apply() {
                return this.reader$9.rest();
            }
            {
                this.reader$9 = reader$9;
            }
        });
        return text.isEmpty() ? None$.MODULE$ : new Some((Object)new Text(HtmlHelpers$.MODULE$.decodeText(text, xml)));
    }

    public Option<Node> parseNode(Reader reader, boolean xml) {
        return (xml ? this.parseCdata(reader) : None$.MODULE$).orElse((Function0)new Serializable(reader, xml){
            public static final long serialVersionUID = 0L;
            private final Reader reader$5;
            private final boolean xml$2;

            public final Option<Tag<?>> apply() {
                return HtmlParser$.MODULE$.parseTag(this.reader$5, this.xml$2);
            }
            {
                this.reader$5 = reader$5;
                this.xml$2 = xml$2;
            }
        }).orElse((Function0)new Serializable(reader, xml){
            public static final long serialVersionUID = 0L;
            private final Reader reader$5;
            private final boolean xml$2;

            public final Option<Text> apply() {
                return HtmlParser$.MODULE$.parseText(this.reader$5, this.xml$2);
            }
            {
                this.reader$5 = reader$5;
                this.xml$2 = xml$2;
            }
        });
    }

    public Option<Tag<?>> parseRootNode(Reader reader, boolean xml) {
        while (this.skipComment(reader)) {
        }
        return this.parseTag(reader, xml);
    }

    public Tag<Object> fromString(String html, boolean xml) {
        Reader reader = new Reader(html);
        reader.skip((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$4) {
                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$4));
            }
        });
        this.skipDocType(reader);
        reader.skip((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$5) {
                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$5));
            }
        });
        if (xml) {
            this.skipXml(reader);
        }
        reader.skip((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$6) {
                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$6));
            }
        });
        return (Tag)this.parseRootNode(reader, xml).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ParseError("Invalid input");
            }
        });
    }

    private final Map f$1(Map acc, Reader reader$2) {
        while (!reader$2.lookahead("/>") && !reader$2.lookahead(">")) {
            Tuple2<String, String> attr = this.parseAttr(reader$2);
            reader$2.skip((Function1<Object, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$1) {
                    return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$1));
                }
            });
            acc = acc.$plus(attr);
        }
        return acc;
    }

    private final List f$2(List nodes, Reader reader$3, String tagName$1, boolean xml$1) {
        Option<Node> option;
        while (true) {
            block5: {
                List list;
                block4: {
                    List list2;
                    block3: {
                        if (!reader$3.prefix(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"</", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName$1})))) break block3;
                        list = nodes;
                        break block4;
                    }
                    if (this.skipComment(reader$3)) continue;
                    option = this.parseNode(reader$3, xml$1);
                    if (!None$.MODULE$.equals(option)) break block5;
                    list = list2 = nodes;
                }
                return list;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            Node t = (Node)some.x();
            nodes = (List)nodes.$colon$plus((Object)t, List$.MODULE$.canBuildFrom());
        }
        throw new MatchError(option);
    }

    private HtmlParser$() {
        MODULE$ = this;
    }
}

