/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ImportMaxQuantTask
extends AbstractJMSTask {
    public static int RESULT_SET_IDS_LIST = 0;
    public static int WARNING_MESSAGES = 1;
    public static int RESULT_SUMMARY_IDS_MAP = 2;
    public static int QUANTITATION_DATASET_ID = 3;
    public static int RESULTS_SIZE = 4;
    private String m_filePath;
    private long m_instrumentId;
    private long m_peaklistSoftwareId;
    private long m_projectId;
    private String m_accessionRegexp;
    private Boolean m_importQuantResult;
    private Object[] m_taskResult = null;

    public ImportMaxQuantTask(AbstractJMSCallback callback, String filePath, long instrumentId, long peaklistSoftwareId, long projectId, Object[] resultsFromTask) {
        super(callback, new TaskInfo("Import MaxQuant file " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_filePath = filePath;
        this.m_instrumentId = instrumentId;
        this.m_peaklistSoftwareId = peaklistSoftwareId;
        this.m_projectId = projectId;
        this.m_importQuantResult = false;
        this.m_accessionRegexp = "*";
        this.m_taskResult = resultsFromTask;
    }

    public ImportMaxQuantTask(AbstractJMSCallback callback, String filePath, long instrumentId, String accessionRegexp, Boolean importQuantitation, long projectId, Object[] resultsFromTask) {
        super(callback, new TaskInfo("Import MaxQuant file " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_filePath = filePath;
        this.m_instrumentId = instrumentId;
        this.m_accessionRegexp = accessionRegexp;
        this.m_importQuantResult = importQuantitation;
        this.m_projectId = projectId;
        this.m_taskResult = resultsFromTask;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ImportMaxQuantResults");
        message.setStringProperty("Proline_ServiceVersion", "2.0");
        this.addSupplementaryInfo((Message)message, this.m_projectId);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            Long datasetId;
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Map.class.isInstance(result)) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
                throw new Exception("Invalid result " + result);
            }
            Map returnedValues = (Map)result;
            List returnedRsIds = (List)returnedValues.get("result_set_Ids");
            if (returnedRsIds == null || returnedRsIds.isEmpty()) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSet Ids");
                throw new Exception("Import result error : No returned ResultSet Ids");
            }
            Map resultSummaries = (Map)returnedValues.get("result_summary_ids_by_result_set_id");
            if (resultSummaries != null && !resultSummaries.isEmpty()) {
                this.m_taskResult[ImportMaxQuantTask.RESULT_SUMMARY_IDS_MAP] = resultSummaries;
            }
            if ((datasetId = (Long)returnedValues.get("quantitation_dataset_id")) != null) {
                this.m_taskResult[ImportMaxQuantTask.QUANTITATION_DATASET_ID] = datasetId;
            }
            this.m_taskResult[ImportMaxQuantTask.RESULT_SET_IDS_LIST] = returnedRsIds;
            this.m_taskResult[ImportMaxQuantTask.WARNING_MESSAGES] = (String)returnedValues.get("warning_msg");
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("result_files_dir", this.m_filePath);
        params.put("instrument_config_id", this.m_instrumentId);
        if (this.m_accessionRegexp != null && !this.m_accessionRegexp.isEmpty()) {
            params.put("accession_regexp", this.m_accessionRegexp);
        }
        params.put("import_quant_result", this.m_importQuantResult);
        return params;
    }
}

