
/* SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */

-- Remove table "admin_infos" --
DROP TABLE admin_infos;

--- Rename column "data_set.children_count" to "data_set.child_count" ---
ALTER TABLE data_set ALTER COLUMN children_count RENAME TO child_count;

-- Remove "username" & "password" fields from "external_db" table --
ALTER TABLE external_db DROP COLUMN username;
ALTER TABLE external_db DROP COLUMN password;

-- Remove "instrument_id" FK from "raw_file" table --
ALTER TABLE raw_file DROP COLUMN instrument_id;

-- Add "ident_data_set_id" and "ident_result_summary_id" columns to "master_quant_channel" table --
ALTER TABLE master_quant_channel ADD COLUMN ident_data_set_id BIGINT;
ALTER TABLE master_quant_channel ADD COLUMN ident_result_summary_id BIGINT;

--- Set "quant_channel.name" as NOT NULL --
ALTER TABLE quant_channel ALTER COLUMN name VARCHAR(100) NOT NULL;

--- Add "number" column to "quant_label" table ---
ALTER TABLE quant_label ADD COLUMN number INTEGER;

--- Add constraint "ident_data_set_master_quant_channel_fk" ---
ALTER TABLE master_quant_channel ADD CONSTRAINT ident_data_set_master_quant_channel_fk
FOREIGN KEY (ident_data_set_id)
REFERENCES data_set (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

--- MANUAL ADDITION: rename constraint "data_set_master_quant_channel_fk" to "quant_data_set_master_quant_channel_fk" ---
ALTER TABLE master_quant_channel DROP CONSTRAINT data_set_master_quant_channel_fk;
ALTER TABLE master_quant_channel ADD CONSTRAINT quant_data_set_master_quant_channel_fk
FOREIGN KEY (quantitation_id)
REFERENCES data_set (id)
ON DELETE CASCADE
ON UPDATE NO ACTION;

-- Add UNIQUE constraint for "quant_channel.name" and a given "master_quant_channel" --
CREATE UNIQUE INDEX quant_channel_unique_name_idx
 ON quant_channel
 ( master_quant_channel_id, name );

CREATE UNIQUE INDEX quant_label_number_idx
 ON quant_label
 ( quant_method_id, number );

-- Add UNIQUE constraint for "quant_label.name" and a given "quant_method" --
CREATE UNIQUE INDEX quant_label_unique_name_idx
 ON quant_label
 ( quant_method_id, name );

CREATE TABLE public.fragmentation_rule_set (
                 id IDENTITY NOT NULL,
                 name VARCHAR(200) NOT NULL,
                 CONSTRAINT fragmentation_rule_set_pk PRIMARY KEY (id)
 );

CREATE UNIQUE INDEX public.fragmentation_rule_set_name_idx
 ON public.fragmentation_rule_set
 ( name );


CREATE TABLE public.fragmentation_rule_set_map (
                 fragmentation_rule_id INTEGER NOT NULL,
                 fragmentation_rule_set_id INTEGER NOT NULL,
                 CONSTRAINT fragmentation_rule_set_map_pk PRIMARY KEY (fragmentation_rule_id, fragmentation_rule_set_id)
 );

ALTER TABLE public.fragmentation_rule_set_map ADD CONSTRAINT fragmentation_rule_set_fragmentation_rule_set_map_fk
FOREIGN KEY (fragmentation_rule_set_id)
REFERENCES public.fragmentation_rule_set (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.fragmentation_rule_set_map ADD CONSTRAINT fragmentation_rule_fragmentation_rule_set_map_fk
FOREIGN KEY (fragmentation_rule_id)
REFERENCES public.fragmentation_rule (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;


/* END OF SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */


/* ADDITIONAL SQL QUERIES USED FOR DATA UPDATE */

-- Set default value to quant_label.number and set as NOT NULL --
UPDATE quant_label SET number = quant_label.id;
ALTER TABLE quant_label ALTER COLUMN number SET NOT NULL;

-- Rename quant_method.type value 'isobaric_tag' to 'isobaric_tagging' --
UPDATE quant_method SET type = 'isobaric_tagging' WHERE type = 'isobaric_tag'; 

-- Set name of existing quant channels (having an empty name) --
UPDATE quant_channel SET name = context_key WHERE (name = '') IS NOT FALSE

/* END OF ADDITIONAL SQL QUERIES USED FOR DATA UPDATE */


/* LIST OF OPERATIONS TO BE PERFORMED IN THE NEXT JAVA MIGRATION */
-- Import of PSdb data into all MSI databases
-- Remove PSdb
-- Fix quant label.number value
-- Put MasterQuantChannelProperties IDs in the master_quant_channel table
-- SpectralCountProperties => weightsRefRSMIds should be weightsRefRsmIds to have the correct serialization key
-- Move spectralCountProperties from MasterQuantChannelProperties to dedicated object tree
-- ResultSummaryRelation is not persisted for XIC (redmine issue #14342)

/* END LIST OF OPERATIONS TO BE PERFORMED IN THE NEXT JAVA MIGRATION */