/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.GUIUtils;

public class CollapsiblePane
extends JPanel {
    private static final Color DEFAULT_TITLE_FOREGROUND = Color.black;
    private static final Color DEFAULT_BORDER_BACKGROUND = new Color(30, 30, 100, 150);
    private static final Dimension DEFAULT_MAX_DIMENSION = new Dimension(1000, 1000);
    private final String title;
    private Component contentComponent;
    private Icon expandIcon;
    private Icon collapseIcon;
    private JLabel iconLabel;

    public CollapsiblePane(String title) {
        this.title = title;
        this.setupMainPane();
        this.addComponents();
    }

    private void setupMainPane() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(DEFAULT_BORDER_BACKGROUND));
        this.setMaximumSize(DEFAULT_MAX_DIMENSION);
    }

    private void addComponents() {
        JComponent titleComponent = this.createTitleComponent();
        this.add((Component)titleComponent, "First");
    }

    private JComponent createTitleComponent() {
        GradientColorPanel panel = new GradientColorPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel label = new JLabel(this.title);
        label.setOpaque(false);
        label.setForeground(DEFAULT_TITLE_FOREGROUND);
        Font font = UIManager.getDefaults().getFont("Label.font");
        label.setFont(new Font(font.getFamily(), 0, font.getSize() + 2));
        panel.add((Component)label, "West");
        new GUIUtils();
        this.expandIcon = GUIUtils.loadIcon("icons/navigation_expand.gif");
        this.collapseIcon = GUIUtils.loadIcon("icons/navigation_collapse.gif");
        this.iconLabel = new JLabel(this.expandIcon);
        panel.add((Component)this.iconLabel, "East");
        panel.addMouseListener(new CollapseListener());
        return panel;
    }

    public void setContentComponent(Component component) {
        this.contentComponent = component;
        this.add(this.contentComponent, "Center");
    }

    private static class GradientColorPanel
    extends JPanel {
        private GradientColorPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.isOpaque()) {
                super.paintComponent(g);
                return;
            }
            Graphics2D ng = (Graphics2D)g.create();
            Color colour1 = this.getBackground().brighter();
            Color colour2 = colour1.darker();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, colour1, 0.0f, this.getHeight(), colour2, true);
            ng.setPaint(gradient);
            ng.fillRect(0, 0, this.getWidth(), this.getHeight());
            ng.dispose();
            this.setOpaque(false);
            super.paintComponent(g);
            this.setOpaque(true);
        }
    }

    private class CollapseListener
    extends MouseAdapter {
        private CollapseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CollapsiblePane.this.contentComponent != null) {
                boolean vis = !CollapsiblePane.this.contentComponent.isVisible();
                CollapsiblePane.this.contentComponent.setVisible(vis);
                if (vis) {
                    CollapsiblePane.this.iconLabel.setIcon(CollapsiblePane.this.expandIcon);
                } else {
                    CollapsiblePane.this.iconLabel.setIcon(CollapsiblePane.this.collapseIcon);
                }
                Container parent = CollapsiblePane.this.getParent();
                parent.repaint();
            }
        }
    }
}

