/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.jdbc;

import fr.profi.jdbc.BatchStatementWrapper;
import fr.profi.jdbc.ISQLFormattable;
import fr.profi.jdbc.PreparedStatementWrapper;
import fr.profi.jdbc.ResultSetRow;
import fr.profi.jdbc.ResultSetRow$;
import fr.profi.jdbc.SQLQueryExecution;
import fr.profi.jdbc.easy.package$;
import fr.profi.util.primitives.package;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public abstract class SQLQueryExecution$class {
    public static int getInExpressionCountLimit(SQLQueryExecution $this) {
        return $this.dialect().inExpressionCountLimit();
    }

    public static Seq select(SQLQueryExecution $this, String sql, Seq params, Function1 block) {
        ArrayBuffer results = new ArrayBuffer();
        SQLQueryExecution$class._selectIntoBuffer($this, (Option)new Some((Object)results), sql, (ISQLFormattable[])params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class)), SQLQueryExecution$class._selectIntoBuffer$default$4($this), block);
        return results;
    }

    public static void selectAndProcess(SQLQueryExecution $this, String sql, Seq params, Function1 block) {
        SQLQueryExecution$class._selectIntoBuffer($this, (Option)None$.MODULE$, sql, (ISQLFormattable[])params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class)), SQLQueryExecution$class._selectIntoBuffer$default$4($this), block);
    }

    public static Map[] selectAllRecordsAsMaps(SQLQueryExecution $this, String sql) {
        ObjectRef colNames = ObjectRef.create(null);
        ArrayBuilder records = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Map.class));
        $this.selectAndProcess(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray((Object)new ISQLFormattable[0]), (Function1<ResultSetRow, BoxedUnit>)new Serializable($this, colNames, records){
            public static final long serialVersionUID = 0L;
            private final ObjectRef colNames$1;
            private final ArrayBuilder records$1;

            public final void apply(ResultSetRow r) {
                if ((String[])this.colNames$1.elem == null) {
                    this.colNames$1.elem = r.columnNames();
                }
                this.records$1.$plus$eq((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.colNames$1.elem)).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final ResultSetRow r$1;

                    public final Tuple2<String, Object> apply(String colName) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)colName), this.r$1.nextAnyRefOrElse((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Null$ apply() {
                                return null;
                            }
                        }));
                    }
                    {
                        this.r$1 = r$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()));
            }
            {
                this.colNames$1 = colNames$1;
                this.records$1 = records$1;
            }
        });
        return (Map[])records.result();
    }

    public static package.AnyMap[] selectAllRecords(SQLQueryExecution $this, String sql) {
        ObjectRef colNames = ObjectRef.create(null);
        ArrayBuilder records = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(package.AnyMap.class));
        $this.selectAndProcess(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray((Object)new ISQLFormattable[0]), (Function1<ResultSetRow, BoxedUnit>)new Serializable($this, colNames, records){
            public static final long serialVersionUID = 0L;
            private final ObjectRef colNames$2;
            private final ArrayBuilder records$2;

            public final void apply(ResultSetRow r) {
                if ((String[])this.colNames$2.elem == null) {
                    this.colNames$2.elem = r.columnNames();
                }
                package.AnyMap record = new package.AnyMap();
                Predef$.MODULE$.refArrayOps((Object[])((String[])this.colNames$2.elem)).foreach((Function1)new Serializable(this, record, r){
                    public static final long serialVersionUID = 0L;
                    private final package.AnyMap record$1;
                    private final ResultSetRow r$2;

                    public final void apply(String colName) {
                        this.record$1.update(colName, this.r$2.nextAnyRefOrElse((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Null$ apply() {
                                return null;
                            }
                        }));
                    }
                    {
                        this.record$1 = record$1;
                        this.r$2 = r$2;
                    }
                });
                this.records$2.$plus$eq((Object)record);
            }
            {
                this.colNames$2 = colNames$2;
                this.records$2 = records$2;
            }
        });
        return (package.AnyMap[])records.result();
    }

    public static Option selectHeadOption(SQLQueryExecution $this, String sql, Seq params, Function1 block) {
        return (Option)SQLQueryExecution$class._usingSelectStatement($this, (Function1)new Serializable($this, sql, params, block){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLQueryExecution $outer;
            private final String sql$2;
            private final Seq params$2;
            private final Function1 block$2;

            public final Option<T> apply(Statement statement) {
                ResultSet rs = statement.executeQuery(this.$outer.dialect().formatSeq(this.sql$2, (ISQLFormattable[])this.params$2.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))));
                return rs.next() ? new Some(this.block$2.apply((Object)ResultSetRow$.MODULE$.apply(rs))) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sql$2 = sql$2;
                this.params$2 = params$2;
                this.block$2 = block$2;
            }
        });
    }

    public static Object selectHeadOrElse(SQLQueryExecution $this, String sql, Seq params, Function1 block, Function0 function0) {
        Option option;
        block4: {
            Object object;
            block3: {
                Object head;
                block2: {
                    Option headOpt = $this.selectHeadOption(sql, (Seq<ISQLFormattable>)params, block);
                    option = headOpt;
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = function0.apply();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                object = head = some.x();
            }
            return object;
        }
        throw new MatchError(option);
    }

    public static Object selectHead(SQLQueryExecution $this, String sql, Seq params, Function1 block) throws NoSuchElementException {
        Option headOpt = $this.selectHeadOption(sql, (Seq<ISQLFormattable>)params, block);
        if (headOpt.isEmpty()) {
            throw new NoSuchElementException(new StringBuilder().append((Object)"can't find a record for this SQL query: '").append((Object)sql).append((Object)"'").toString());
        }
        return headOpt.get();
    }

    public static long selectLong(SQLQueryExecution $this, String sql, Seq params) {
        return BoxesRunTime.unboxToLong($this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(ResultSetRow row) {
                return package$.MODULE$.row2Long(row);
            }
        }));
    }

    public static long[] selectLongs(SQLQueryExecution $this, String sql, Seq params) {
        ArrayBuffer results = new ArrayBuffer();
        SQLQueryExecution$class._selectIntoBuffer($this, (Option)new Some((Object)results), sql, (ISQLFormattable[])params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class)), SQLQueryExecution$class._selectIntoBuffer$default$4($this), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(ResultSetRow row) {
                return package$.MODULE$.row2Long(row);
            }
        });
        return (long[])results.toArray(ClassTag$.MODULE$.Long());
    }

    public static int selectInt(SQLQueryExecution $this, String sql, Seq params) {
        return BoxesRunTime.unboxToInt($this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(ResultSetRow row) {
                return package$.MODULE$.row2Int(row);
            }
        }));
    }

    public static int[] selectInts(SQLQueryExecution $this, String sql, Seq params) {
        ArrayBuffer results = new ArrayBuffer();
        SQLQueryExecution$class._selectIntoBuffer($this, (Option)new Some((Object)results), sql, (ISQLFormattable[])params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class)), SQLQueryExecution$class._selectIntoBuffer$default$4($this), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(ResultSetRow row) {
                return package$.MODULE$.row2Int(row);
            }
        });
        return (int[])results.toArray(ClassTag$.MODULE$.Int());
    }

    public static boolean selectBoolean(SQLQueryExecution $this, String sql, Seq params) {
        return BoxesRunTime.unboxToBoolean($this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ResultSetRow row) {
                return package$.MODULE$.row2Boolean(row);
            }
        }));
    }

    public static String selectString(SQLQueryExecution $this, String sql, Seq params) {
        return (String)$this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ResultSetRow row) {
                return package$.MODULE$.row2String(row);
            }
        });
    }

    public static float selectFloat(SQLQueryExecution $this, String sql, Seq params) {
        return BoxesRunTime.unboxToFloat($this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final float apply(ResultSetRow row) {
                return package$.MODULE$.row2Float(row);
            }
        }));
    }

    public static double selectDouble(SQLQueryExecution $this, String sql, Seq params) {
        return BoxesRunTime.unboxToDouble($this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(ResultSetRow row) {
                return package$.MODULE$.row2Double(row);
            }
        }));
    }

    public static DateTime selectDateTime(SQLQueryExecution $this, String sql, Seq params) {
        return (DateTime)$this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final DateTime apply(ResultSetRow row) {
                return package$.MODULE$.row2DateTime(row);
            }
        });
    }

    public static Timestamp selectTimestamp(SQLQueryExecution $this, String sql, Seq params) {
        return (Timestamp)$this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Timestamp apply(ResultSetRow row) {
                return package$.MODULE$.row2Timestamp(row);
            }
        });
    }

    public static Duration selectDuration(SQLQueryExecution $this, String sql, Seq params) {
        return (Duration)$this.selectHead(sql, (Seq<ISQLFormattable>)Predef$.MODULE$.genericWrapArray(params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Duration apply(ResultSetRow row) {
                return package$.MODULE$.row2Duration(row);
            }
        });
    }

    private static void _selectIntoBuffer(SQLQueryExecution $this, Option buffer, String sql, ISQLFormattable[] params, int maxRecords, Function1 block) {
        SQLQueryExecution$class._usingSelectStatement($this, (Function1)new Serializable($this, buffer, sql, params, block){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLQueryExecution $outer;
            private final Option buffer$1;
            private final String sql$1;
            private final ISQLFormattable[] params$1;
            private final Function1 block$1;

            public final void apply(Statement statement) {
                ResultSet rs = statement.executeQuery(this.$outer.dialect().formatSeq(this.sql$1, this.params$1));
                boolean append = this.buffer$1.isDefined();
                while (rs.next()) {
                    Object value = this.block$1.apply((Object)ResultSetRow$.MODULE$.apply(rs));
                    if (!append) continue;
                    ((BufferLike)this.buffer$1.get()).append((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.buffer$1 = buffer$1;
                this.sql$1 = sql$1;
                this.params$1 = params$1;
                this.block$1 = block$1;
            }
        });
    }

    private static int _selectIntoBuffer$default$4(SQLQueryExecution $this) {
        return 0;
    }

    private static Object _usingSelectStatement(SQLQueryExecution $this, Function1 block) {
        boolean oldAutoCommit = $this.connection().getAutoCommit();
        if ($this.dialect().fetchSize().isDefined()) {
            $this.connection().setAutoCommit(false);
        }
        Statement statement = $this.connection().createStatement();
        $this.dialect().fetchSize().foreach((Function1)new Serializable($this, statement){
            public static final long serialVersionUID = 0L;
            private final Statement statement$1;

            public final int apply(int fetchSize) {
                return this.apply$mcII$sp(fetchSize);
            }

            public int apply$mcII$sp(int fetchSize) {
                this.statement$1.setFetchSize(fetchSize);
                return this.statement$1.getResultSetType();
            }
            {
                this.statement$1 = statement$1;
            }
        });
        try {
            return block.apply((Object)statement);
        }
        finally {
            statement.close();
            if ($this.dialect().fetchSize().isDefined() && $this.connection().getAutoCommit() != oldAutoCommit) {
                $this.connection().setAutoCommit(oldAutoCommit);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int execute(SQLQueryExecution $this, String sql, Seq params) {
        int n;
        Statement statement = $this.connection().createStatement();
        try {
            String sqlString = $this.dialect().formatSeq(sql, (ISQLFormattable[])params.toArray(ClassTag$.MODULE$.apply(ISQLFormattable.class)));
            n = statement.executeUpdate(sqlString);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        statement.close();
        return n;
    }

    public static PreparedStatementWrapper prepareStatementWrapper(SQLQueryExecution $this, String sql, boolean generateKeys) {
        int keysOption = generateKeys ? 1 : 2;
        return new PreparedStatementWrapper($this.connection().prepareStatement(sql, keysOption), $this.dialect());
    }

    public static boolean prepareStatementWrapper$default$2(SQLQueryExecution $this) {
        return false;
    }

    public static Object executePrepared(SQLQueryExecution $this, String sql, boolean generateKeys, Function1 block) {
        return SQLQueryExecution$class._usingPreparedStatement($this, sql, generateKeys, block);
    }

    public static boolean executePrepared$default$2(SQLQueryExecution $this) {
        return false;
    }

    public static int[] executeInBatch(SQLQueryExecution $this, String sql, Function1 block) {
        return SQLQueryExecution$class._usingBatch($this, sql, block);
    }

    /*
     * WARNING - void declaration
     */
    private static Object _usingPreparedStatement(SQLQueryExecution $this, String sql, boolean generateKeys, Function1 block) {
        Object object;
        PreparedStatementWrapper statement = $this.prepareStatementWrapper(sql, generateKeys);
        try {
            object = block.apply((Object)statement);
            statement.close();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        return object;
    }

    private static boolean _usingPreparedStatement$default$2(SQLQueryExecution $this) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] _usingBatch(SQLQueryExecution $this, String sql, Function1 block) {
        int[] nArray;
        BatchStatementWrapper statement = new BatchStatementWrapper($this.connection().prepareStatement(sql), $this.dialect());
        try {
            block.apply((Object)statement);
            nArray = statement.jdbcPrepStmt().executeBatch();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        statement.close();
        return nArray;
    }

    public static void $init$(SQLQueryExecution $this) {
    }
}

