/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.context;

import fr.proline.repository.DriverType;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.repository.util.JDBCReturningWork;
import fr.proline.repository.util.JDBCWork;
import fr.proline.repository.util.JPAUtils;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionContext
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseConnectionContext.class);
    private static final boolean DEBUG_LEAK = true;
    private final Exception m_fakeException;
    private final EntityManager m_entityManager;
    private final ProlineDatabaseType m_prolineDatabaseType;
    private final DriverType m_driverType;
    private final Object m_contextLock = new Object();
    private Connection m_connection;
    private boolean m_closableConnection = true;
    private boolean m_closed;
    private Runnable m_onClose;

    protected DatabaseConnectionContext(EntityManager entityManager, ProlineDatabaseType prolineDatabaseType, DriverType driverType) {
        this(entityManager, null, prolineDatabaseType, driverType);
    }

    public DatabaseConnectionContext(IDatabaseConnector dbConnector) {
        this(dbConnector.createEntityManager(), dbConnector.getProlineDatabaseType(), dbConnector.getDriverType());
    }

    public DatabaseConnectionContext(Connection connection, ProlineDatabaseType prolineDatabaseType, DriverType driverType) {
        this(null, connection, prolineDatabaseType, driverType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseConnectionContext(EntityManager entityManager, Connection connection, ProlineDatabaseType prolineDatabaseType, DriverType driverType) {
        if (entityManager == null && connection == null) {
            throw new IllegalArgumentException("EntityManager and Connection are both null");
        }
        this.m_fakeException = new RuntimeException("_FakeException_ DatabaseConnectionContext instance creation");
        this.m_entityManager = entityManager;
        this.m_prolineDatabaseType = prolineDatabaseType;
        this.m_driverType = driverType;
        Object object = this.m_contextLock;
        synchronized (object) {
            this.m_connection = connection;
        }
    }

    public EntityManager getEntityManager() {
        if (this.isClosed()) {
            throw new IllegalStateException("Context ALREADY closed");
        }
        return this.m_entityManager;
    }

    public boolean isJPA() {
        return this.getEntityManager() != null;
    }

    public ProlineDatabaseType getProlineDatabaseType() {
        return this.m_prolineDatabaseType;
    }

    public DriverType getDriverType() {
        return this.m_driverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection result;
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            result = this.m_connection;
        }
        return result;
    }

    public DatabaseConnectionContext setClosableConnection(boolean closableConnection) {
        this.m_closableConnection = closableConnection;
        return this;
    }

    public void setOnCloseCallback(Runnable onClose) {
        this.m_onClose = onClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInTransaction() throws SQLException {
        boolean result = false;
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            if (this.isJPA()) {
                EntityTransaction currentTransaction = this.getEntityManager().getTransaction();
                result = currentTransaction != null && currentTransaction.isActive();
            } else {
                Connection contextConnection = this.getConnection();
                if (contextConnection != null && !contextConnection.isClosed()) {
                    result = !contextConnection.getAutoCommit();
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} isInTransaction : {}", (Object)this.getProlineDatabaseTypeString(), (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() throws SQLException {
        Object object = this.m_contextLock;
        synchronized (object) {
            Connection contextConnection;
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Begin Transaction from DatabaseConnectionContext", (Object)this.getProlineDatabaseTypeString());
            }
            if (this.isJPA()) {
                this.getEntityManager().getTransaction().begin();
            } else {
                this.getConnection().setAutoCommit(false);
            }
            if (LOG.isDebugEnabled() && (contextConnection = this.getConnection()) != null) {
                LOG.debug("{} SQL TransactionIsolation \"{}\"", (Object)this.getProlineDatabaseTypeString(), (Object)DatabaseConnectionContext.formatTransactionIsolationLevel(contextConnection.getTransactionIsolation()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() throws SQLException {
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Commit Transaction from DatabaseConnectionContext", (Object)this.getProlineDatabaseTypeString());
            }
            if (this.isJPA()) {
                this.getEntityManager().getTransaction().commit();
            } else {
                Connection contextConnection = this.getConnection();
                contextConnection.commit();
                contextConnection.setAutoCommit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws SQLException {
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Rollback Transaction from DatabaseConnectionContext", (Object)this.getProlineDatabaseTypeString());
            }
            if (this.getDriverType() == DriverType.SQLITE) {
                LOG.warn("Rollbacking Transaction with SQLITE Database does NOTHING");
            } else if (this.isJPA()) {
                this.getEntityManager().getTransaction().rollback();
            } else {
                this.getConnection().rollback();
            }
        }
    }

    @Override
    public void close() {
        this.doClose(false);
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.doClose(true);
            }
            catch (Exception ex) {
                LOG.error("Error closing " + this.getProlineDatabaseTypeString() + " Context", (Throwable)ex);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean result;
        Object object = this.m_contextLock;
        synchronized (object) {
            result = this.m_closed;
        }
        return result;
    }

    public void doTableTriggerAlter(final String tableName, final String alterAction) throws SQLException {
        if (tableName == null || tableName.isEmpty() || !"DISABLE".equals(alterAction.toUpperCase()) && !"ENABLE".equals(alterAction.toUpperCase())) {
            throw new IllegalArgumentException("TableName is not specicied or action is not ENABLE or DISABLE.");
        }
        if (this.getDriverType().equals((Object)DriverType.POSTGRESQL)) {
            JDBCWork triggerAction = new JDBCWork(){

                public void execute(Connection connection) throws SQLException {
                    Statement s = connection.createStatement();
                    s.execute(" ALTER TABLE " + tableName + " " + alterAction + " TRIGGER ALL;");
                }
            };
            this.doWork(triggerAction, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(final JDBCWork work, boolean flushEntityManager) throws SQLException {
        if (work == null) {
            throw new IllegalArgumentException("Work is null");
        }
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            Connection contextConnection = this.getConnection();
            if (contextConnection == null) {
                EntityManager contextEntityMananger = this.getEntityManager();
                JPAUtils.checkEntityManager(contextEntityMananger);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Executing JDBCWork on JPA EntityManager, flushEntityManager: {}", (Object)this.getProlineDatabaseTypeString(), (Object)flushEntityManager);
                }
                if (flushEntityManager) {
                    contextEntityMananger.flush();
                }
                JDBCWork contextWork = new JDBCWork(){

                    public void execute(Connection con) throws SQLException {
                        DatabaseConnectionContext.this.m_connection = con;
                        try {
                            work.execute(con);
                        }
                        finally {
                            DatabaseConnectionContext.this.m_connection = null;
                        }
                    }
                };
                JPAUtils.doWork(contextEntityMananger, contextWork);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Executing JDBCWork on raw JDBC Connection", (Object)this.getProlineDatabaseTypeString());
                }
                work.execute(contextConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doReturningWork(final JDBCReturningWork<T> returningWork, boolean flushEntityManager) throws SQLException {
        if (returningWork == null) {
            throw new IllegalArgumentException("ReturningWork is null");
        }
        Object result = null;
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Context ALREADY closed");
            }
            Connection contextConnection = this.getConnection();
            if (contextConnection == null) {
                EntityManager contextEntityMananger = this.getEntityManager();
                JPAUtils.checkEntityManager(contextEntityMananger);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Executing JDBCReturningWork on JPA EntityManager, flushEntityManager: {}", (Object)this.getProlineDatabaseTypeString(), (Object)flushEntityManager);
                }
                if (flushEntityManager) {
                    contextEntityMananger.flush();
                }
                JDBCReturningWork contextReturningWork = new JDBCReturningWork<T>(){

                    public T execute(Connection con) throws SQLException {
                        Object innerResult;
                        DatabaseConnectionContext.this.m_connection = con;
                        try {
                            innerResult = returningWork.execute(con);
                        }
                        finally {
                            DatabaseConnectionContext.this.m_connection = null;
                        }
                        return innerResult;
                    }
                };
                result = JPAUtils.doReturningWork(contextEntityMananger, contextReturningWork);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Executing JDBCReturningWork on raw JDBC Connection", (Object)this.getProlineDatabaseTypeString());
                }
                result = returningWork.execute(contextConnection);
            }
        }
        return (T)result;
    }

    private String getProlineDatabaseTypeString() {
        String result = null;
        ProlineDatabaseType dbType = this.getProlineDatabaseType();
        result = dbType == null ? "Unknown Db" : (Object)((Object)dbType) + " Db";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doClose(boolean fromFinalize) {
        Object object = this.m_contextLock;
        synchronized (object) {
            if (this.m_closed) return;
            this.m_closed = true;
            String prolineDbType = this.getProlineDatabaseTypeString();
            if (this.m_connection != null && this.m_closableConnection) {
                if (fromFinalize) {
                    LOG.warn("Trying to close ORPHAN {} Context from finalize", (Object)prolineDbType, (Object)this.m_fakeException);
                }
                try {
                    this.m_connection.close();
                }
                catch (SQLException exClose) {
                    LOG.error("Error closing DatabaseConnectionContext SQL Connection for " + prolineDbType, (Throwable)exClose);
                }
            } else {
                if (this.m_entityManager == null) return;
                if (fromFinalize) {
                    LOG.warn("Trying to close ORPHAN {} Context from finalize", (Object)prolineDbType, (Object)this.m_fakeException);
                }
                try {
                    EntityTransaction currentTransaction = this.m_entityManager.getTransaction();
                    if (currentTransaction == null) return;
                    if (!currentTransaction.isActive()) return;
                    LOG.info("{} Rollback EntityTransaction from DatabaseConnectionContext.doClose()", (Object)prolineDbType);
                    try {
                        currentTransaction.rollback();
                    }
                    catch (Exception ex) {
                        LOG.error("Error rollbacking DatabaseConnectionContext EntityTransaction for " + prolineDbType, (Throwable)ex);
                    }
                }
                finally {
                    try {
                        if (!fromFinalize || this.m_entityManager.isOpen()) {
                            this.m_entityManager.close();
                        }
                    }
                    catch (Exception exClose) {
                        LOG.error("Error closing DatabaseConnectionContext EntityManager for " + prolineDbType, (Throwable)exClose);
                    }
                    finally {
                        if (this.m_onClose != null) {
                            this.m_onClose.run();
                        }
                    }
                }
            }
            return;
        }
    }

    private static String formatTransactionIsolationLevel(int transactionIsolationLevel) {
        String result = null;
        switch (transactionIsolationLevel) {
            case 0: {
                result = "none";
                break;
            }
            case 2: {
                result = "read committed";
                break;
            }
            case 1: {
                result = "read uncommitted";
                break;
            }
            case 4: {
                result = "repeatable read";
                break;
            }
            case 8: {
                result = "serializable";
                break;
            }
            default: {
                result = "?";
            }
        }
        return result;
    }
}

