/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    @Override
    public String nextHexString(int len) {
        if (len <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("length must be positive ({0})", len);
        }
        RandomGenerator ran = this.getRan();
        StringBuffer outBuffer = new StringBuffer();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = randomBytes[i];
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        RandomGenerator rand = this.getRan();
        double r = rand.nextDouble();
        return (int)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    @Override
    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        RandomGenerator rand = this.getRan();
        double r = rand.nextDouble();
        return (long)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    @Override
    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("length must be positive ({0})", len);
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuffer outBuffer = new StringBuffer();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i = 0; i < hash.length; ++i) {
                Integer c = hash[i];
                String hex = Integer.toHexString(c + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (int)(sec.nextDouble() * (double)(upper - lower + 1));
    }

    @Override
    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (long)(sec.nextDouble() * (double)(upper - lower + 1L));
    }

    @Override
    public long nextPoisson(double mean) {
        if (mean <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("the Poisson mean must be positive ({0})", mean);
        }
        RandomGenerator rand = this.getRan();
        double pivot = 6.0;
        if (mean < pivot) {
            double p = Math.exp(-mean);
            long n = 0L;
            double r = 1.0;
            double rnd = 1.0;
            while ((double)n < 1000.0 * mean) {
                rnd = rand.nextDouble();
                if ((r *= rnd) >= p) {
                    ++n;
                    continue;
                }
                return n;
            }
            return n;
        }
        double mu = Math.floor(mean);
        double delta = Math.floor(pivot + (mu - pivot) / 2.0);
        double mu2delta = 2.0 * mu + delta;
        double muDeltaHalf = mu + delta / 2.0;
        double logMeanMu = Math.log(mean / mu);
        double muFactorialLog = MathUtils.factorialLog((int)mu);
        double c1 = Math.sqrt(Math.PI * mu / 2.0);
        double c2 = c1 + Math.sqrt(Math.PI * muDeltaHalf / (2.0 * Math.exp(1.0 / mu2delta)));
        double c3 = c2 + 2.0;
        double c4 = c3 + Math.exp(0.01282051282051282);
        double c = c4 + 2.0 / delta * mu2delta * Math.exp(-delta / mu2delta * (1.0 + delta / 2.0));
        double y = 0.0;
        double x = 0.0;
        double w = Double.POSITIVE_INFINITY;
        boolean accept = false;
        while (!accept) {
            double z;
            double u = this.nextUniform(0.0, c);
            double e = this.nextExponential(mean);
            if (u <= c1) {
                z = this.nextGaussian(0.0, 1.0);
                y = -Math.abs(z) * Math.sqrt(mu) - 1.0;
                x = Math.floor(y);
                w = -z * z / 2.0 - e - x * logMeanMu;
                if (x < -mu) {
                    w = Double.POSITIVE_INFINITY;
                }
            } else if (c1 < u && u <= c2) {
                z = this.nextGaussian(0.0, 1.0);
                y = 1.0 + Math.abs(z) * Math.sqrt(muDeltaHalf);
                x = Math.ceil(y);
                w = (-y * y + 2.0 * y) / mu2delta - e - x * logMeanMu;
                if (x > delta) {
                    w = Double.POSITIVE_INFINITY;
                }
            } else if (c2 < u && u <= c3) {
                x = 0.0;
                w = -e;
            } else if (c3 < u && u <= c4) {
                x = 1.0;
                w = -e - logMeanMu;
            } else if (c4 < u) {
                double v = this.nextExponential(mean);
                y = delta + v * 2.0 / delta * mu2delta;
                x = Math.ceil(y);
                w = -delta / mu2delta * (1.0 + y / 2.0) - e - x * logMeanMu;
            }
            accept = w <= x * Math.log(mu) - MathUtils.factorialLog((int)(mu + x)) / muFactorialLog;
        }
        return (long)(x + mu);
    }

    @Override
    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("standard deviation must be positive ({0})", sigma);
        }
        RandomGenerator rand = this.getRan();
        return sigma * rand.nextGaussian() + mu;
    }

    @Override
    public double nextExponential(double mean) {
        if (mean < 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("mean must be positive ({0})", mean);
        }
        RandomGenerator rand = this.getRan();
        double unif = rand.nextDouble();
        while (unif == 0.0) {
            unif = rand.nextDouble();
        }
        return -mean * Math.log(unif);
    }

    @Override
    public double nextUniform(double lower, double upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        RandomGenerator rand = this.getRan();
        double u = rand.nextDouble();
        while (u <= 0.0) {
            u = rand.nextDouble();
        }
        return lower + u * (upper - lower);
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
            this.rand.setSeed(System.currentTimeMillis());
        }
        return this.rand;
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis());
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(System.currentTimeMillis());
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    @Override
    public int[] nextPermutation(int n, int k) {
        if (k > n) {
            throw MathRuntimeException.createIllegalArgumentException("permutation k ({0}) exceeds n ({1})", k, n);
        }
        if (k == 0) {
            throw MathRuntimeException.createIllegalArgumentException("permutation k ({0}) must be positive", k);
        }
        int[] index = this.getNatural(n);
        this.shuffle(index, n - k);
        int[] result = new int[k];
        for (int i = 0; i < k; ++i) {
            result[i] = index[n - i - 1];
        }
        return result;
    }

    @Override
    public Object[] nextSample(Collection<?> c, int k) {
        int len = c.size();
        if (k > len) {
            throw MathRuntimeException.createIllegalArgumentException("sample size ({0}) exceeds collection size ({1})", new Object[0]);
        }
        if (k <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("sample size must be positive ({0})", k);
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i = list.length - 1; i >= end; --i) {
            target = i == 0 ? 0 : this.nextInt(0, i);
            int temp = list[target];
            list[target] = list[i];
            list[i] = temp;
        }
    }

    private int[] getNatural(int n) {
        int[] natural = new int[n];
        for (int i = 0; i < n; ++i) {
            natural[i] = i;
        }
        return natural;
    }
}

