/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.data;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import java.sql.Timestamp;

public class ClearProjectData {
    public static final String TYPE_RS = "Search Result";
    public static final String TYPE_RSM = "Identification Summary";
    private long m_projectId;
    private ResultSummary m_rsm;
    private ResultSet m_rs;
    private boolean m_isSelected;
    private boolean m_isEditable;

    public ClearProjectData(long m_projectId, ResultSet m_rs) {
        this.m_projectId = m_projectId;
        this.m_rs = m_rs;
        this.m_rsm = null;
        this.m_isSelected = false;
        this.m_isEditable = true;
    }

    public ClearProjectData(long m_projectId, ResultSummary m_rsm) {
        this.m_projectId = m_projectId;
        this.m_rs = null;
        this.m_rsm = m_rsm;
        this.m_isSelected = true;
        this.m_isEditable = true;
    }

    public boolean isResultSet() {
        return this.m_rsm == null;
    }

    public boolean isResultSummary() {
        return this.m_rsm != null;
    }

    public ResultSet getResultSet() {
        if (this.isResultSet()) {
            return this.m_rs;
        }
        return this.m_rsm.getResultSet();
    }

    public ResultSummary getResultSummary() {
        return this.m_rsm;
    }

    public long getProjectId() {
        return this.m_projectId;
    }

    public Long getId() {
        if (this.isResultSummary()) {
            return this.m_rsm.getId();
        }
        return this.m_rs.getId();
    }

    public String getType() {
        if (this.isResultSummary()) {
            String rsmType = "";
            switch (this.m_rsm.getResultSet().getType()) {
                case SEARCH: {
                    break;
                }
                case DECOY_SEARCH: {
                    rsmType = "DECOY";
                    break;
                }
                case USER: {
                    break;
                }
                case DECOY_USER: {
                    rsmType = "DECOY";
                    break;
                }
                case QUANTITATION: {
                    rsmType = "QUANTITATION";
                }
            }
            return "Identification Summary (" + rsmType + ")";
        }
        return "Search Result (" + this.m_rs.getType() + ")";
    }

    public String getRsName() {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getName();
        }
        return "";
    }

    public MsiSearch getMsiSearch() {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMsiSearch();
        }
        return null;
    }

    public String getPeaklistPath() {
        MsiSearch msiS = this.getMsiSearch();
        if (msiS != null && msiS.getPeaklist() != null) {
            return msiS.getPeaklist().getPath();
        }
        return "";
    }

    public String getMsiSearchFileName() {
        MsiSearch msiS = this.getMsiSearch();
        if (msiS != null) {
            return msiS.getResultFileName();
        }
        return "";
    }

    public String getMsiSearchDirectory() {
        MsiSearch msiS = this.getMsiSearch();
        if (msiS != null) {
            return msiS.getResultFileDirectory();
        }
        return "";
    }

    public Timestamp getMsiSearchDate() {
        MsiSearch msiS = this.getMsiSearch();
        if (msiS != null) {
            return msiS.getDate();
        }
        return null;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.m_isSelected = isSelected;
    }

    public boolean isEditable() {
        return this.m_isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this.m_isEditable = isEditable;
    }
}

