/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.xic;

import fr.proline.core.orm.msi.MasterQuantComponent;
import fr.proline.core.orm.msi.ProteinSet;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseModifyPeptideTask
extends AbstractDatabaseTask {
    private int m_action;
    private ArrayList<DMasterQuantPeptide> m_masterQuantPeptideList;
    private ArrayList<DMasterQuantProteinSet> m_masterQuantProteinSetModified;
    private DDataset m_dataset;
    private long m_projectId;
    private static final int MODIFY_MASTER_QUANT_PEPTIDE = 0;
    private static final int REMOVE_PEPTIDEMODIFIED_ON_PROTEIN = 1;

    public DatabaseModifyPeptideTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initDisablePeptide(long projectId, ArrayList<DMasterQuantPeptide> masterQuantPeptideList, ArrayList<DMasterQuantProteinSet> masterQuantProteinSetModified) {
        this.setTaskInfo(new TaskInfo("Disable Peptide", true, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_action = 0;
        this.m_projectId = projectId;
        this.m_masterQuantPeptideList = masterQuantPeptideList;
        this.m_masterQuantProteinSetModified = masterQuantProteinSetModified;
        this.setPriority(AbstractDatabaseTask.Priority.TOP);
    }

    public void initRemovePeptideModifiedOnProtein(long projectId, DDataset dataset, ArrayList<DMasterQuantProteinSet> masterQuantProteinSetModified) {
        this.setTaskInfo(new TaskInfo("Post-Processed Proteins", true, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_action = 1;
        this.m_projectId = projectId;
        this.m_masterQuantProteinSetModified = masterQuantProteinSetModified;
        this.m_dataset = dataset;
        this.setPriority(AbstractDatabaseTask.Priority.TOP);
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.modifyMasterQuantPeptide();
            }
            case 1: {
                return this.removePeptideModifiedOnProtein();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeptideModifiedOnProtein() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            int nb = this.m_masterQuantProteinSetModified.size();
            ArrayList<Long> masterQuantProteinSetModifiedIDs = new ArrayList<Long>(nb);
            HashMap<Long, DMasterQuantProteinSet> map = new HashMap<Long, DMasterQuantProteinSet>();
            for (int i = 0; i < nb; ++i) {
                DMasterQuantProteinSet dmasterQuantProteinSet = this.m_masterQuantProteinSetModified.get(i);
                Long id = dmasterQuantProteinSet.getId();
                masterQuantProteinSetModifiedIDs.add(dmasterQuantProteinSet.getId());
                map.put(id, dmasterQuantProteinSet);
            }
            String queryMasterQuantProteinSet = "SELECT q FROM MasterQuantComponent q  WHERE q.id IN (:mqproteinSetIds) ";
            TypedQuery masterQuantProteinSetsQuery = entityManagerMSI.createQuery(queryMasterQuantProteinSet, MasterQuantComponent.class);
            masterQuantProteinSetsQuery.setParameter("mqproteinSetIds", masterQuantProteinSetModifiedIDs);
            List masterQuantProteinSets = masterQuantProteinSetsQuery.getResultList();
            for (MasterQuantComponent masterQuantProteinSet : masterQuantProteinSets) {
                Map pmqSerializedMap = masterQuantProteinSet.getSerializedPropertiesAsMap();
                if (pmqSerializedMap == null) continue;
                pmqSerializedMap.put("selection_changed", Boolean.FALSE);
                if (pmqSerializedMap.isEmpty()) {
                    masterQuantProteinSet.setSerializedProperties(null);
                } else {
                    masterQuantProteinSet.setSerializedPropertiesAsMap(pmqSerializedMap);
                }
                ((DMasterQuantProteinSet)map.get(masterQuantProteinSet.getId())).setSerializedProperties(masterQuantProteinSet.getSerializedProperties());
                entityManagerMSI.merge((Object)masterQuantProteinSet);
            }
            ArrayList<Long> proteinSetIds = new ArrayList<Long>(this.m_masterQuantProteinSetModified.size());
            for (DMasterQuantProteinSet masterQuantProteinSet : this.m_masterQuantProteinSetModified) {
                proteinSetIds.add(masterQuantProteinSet.getProteinSetId());
            }
            DatabaseLoadXicMasterQuantTask.fetchProteinSetData(entityManagerMSI, this.m_dataset, this.m_masterQuantProteinSetModified, proteinSetIds);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyMasterQuantPeptide() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            int nbPeptides = this.m_masterQuantPeptideList.size();
            ArrayList<Long> peptideInstanceIdList = new ArrayList<Long>(nbPeptides);
            for (int i = 0; i < nbPeptides; ++i) {
                DMasterQuantPeptide masterQuantPeptide = this.m_masterQuantPeptideList.get(i);
                MasterQuantComponent peptideMasterQuantComponent = (MasterQuantComponent)entityManagerMSI.find(MasterQuantComponent.class, (Object)masterQuantPeptide.getId());
                peptideMasterQuantComponent.setSelectionLevel(masterQuantPeptide.getSelectionLevel());
                entityManagerMSI.merge((Object)peptideMasterQuantComponent);
                DPeptideInstance peptideInstance = masterQuantPeptide.getPeptideInstance();
                long id = peptideInstance.getId();
                peptideInstanceIdList.add(id);
            }
            TypedQuery proteinSetsQuery = entityManagerMSI.createQuery("SELECT prots FROM fr.proline.core.orm.msi.ProteinSet prots, fr.proline.core.orm.msi.PeptideSet peps, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem peps_to_pepi WHERE peps.proteinSet=prots AND peps.id=peps_to_pepi.id.peptideSetId AND peps_to_pepi.id.peptideInstanceId IN (:peptideInstanceId) AND prots.isValidated=true ORDER BY peps.score DESC", ProteinSet.class);
            proteinSetsQuery.setParameter("peptideInstanceId", peptideInstanceIdList);
            List proteinSets = proteinSetsQuery.getResultList();
            for (ProteinSet proteinSet : proteinSets) {
                String queryDMasterQuantProteinSet = "SELECT new fr.proline.core.orm.msi.dto.DMasterQuantProteinSet(q.id,  q.selectionLevel, q.objectTreeId,  q.serializedProperties,  p.resultSummary.id,  p.id)  FROM MasterQuantComponent q,  ProteinSet p  WHERE p.id = :proteinSetId AND   q.id = p.masterQuantComponentId  ORDER BY q.id ASC ";
                TypedQuery masterQuantProteinSetsQuery = entityManagerMSI.createQuery(queryDMasterQuantProteinSet, DMasterQuantProteinSet.class);
                masterQuantProteinSetsQuery.setParameter("proteinSetId", (Object)proteinSet.getId());
                DMasterQuantProteinSet masterQuantProteinSet = (DMasterQuantProteinSet)masterQuantProteinSetsQuery.getSingleResult();
                this.m_masterQuantProteinSetModified.add(masterQuantProteinSet);
                MasterQuantComponent proteinSetMasterQuantComponent = (MasterQuantComponent)entityManagerMSI.find(MasterQuantComponent.class, (Object)proteinSet.getMasterQuantComponentId());
                if (proteinSetMasterQuantComponent == null) continue;
                HashMap<String, Boolean> pmqSerializedMap = proteinSetMasterQuantComponent.getSerializedPropertiesAsMap();
                if (pmqSerializedMap == null) {
                    pmqSerializedMap = new HashMap<String, Boolean>();
                }
                pmqSerializedMap.put("selection_changed", Boolean.TRUE);
                proteinSetMasterQuantComponent.setSerializedPropertiesAsMap(pmqSerializedMap);
                entityManagerMSI.merge((Object)proteinSetMasterQuantComponent);
                masterQuantProteinSet.setSerializedProperties(proteinSetMasterQuantComponent.getSerializedProperties());
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

