/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderFormat;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.template.FastaHeaderFormatInterface;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaWriter<S extends Sequence<?>, C extends Compound> {
    private static final Logger logger = LoggerFactory.getLogger(FastaWriter.class);
    OutputStream os;
    Collection<S> sequences;
    FastaHeaderFormatInterface<S, C> headerFormat;
    private int lineLength = 60;
    byte[] lineSep = System.getProperty("line.separator").getBytes();

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
    }

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSep = lineSeparator.getBytes();
    }

    public void process() throws IOException {
        for (Sequence sequence : this.sequences) {
            String header = this.headerFormat.getHeader(sequence);
            this.os.write(62);
            this.os.write(header.getBytes());
            this.os.write(this.lineSep);
            int compoundCount = 0;
            String seq = "";
            seq = sequence.getSequenceAsString();
            for (int i = 0; i < seq.length(); ++i) {
                this.os.write(seq.charAt(i));
                if (++compoundCount != this.lineLength) continue;
                this.os.write(this.lineSep);
                compoundCount = 0;
            }
            if (sequence.getLength() % this.getLineLength() == 0) continue;
            this.os.write(this.lineSep);
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("/Users/Scooter/scripps/dyadic/c1-454Scaffolds.faa");
            FastaReader fastaReader = new FastaReader(is, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            is.close();
            FileOutputStream fileOutputStream = new FileOutputStream("/Users/Scooter/scripps/dyadic/c1-454Scaffolds_temp.faa");
            BufferedOutputStream bo = new BufferedOutputStream(fileOutputStream);
            long start = System.currentTimeMillis();
            FastaWriter fastaWriter = new FastaWriter(bo, proteinSequences.values(), new GenericFastaHeaderFormat());
            fastaWriter.process();
            bo.close();
            long end = System.currentTimeMillis();
            logger.info("Took {} seconds", (Object)(end - start));
            fileOutputStream.close();
        }
        catch (IOException e) {
            logger.warn("Exception: ", (Throwable)e);
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

