/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.profi.mzdb.model.Peakel;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePeakel
implements IPeakel {
    private static final Logger logger = LoggerFactory.getLogger(BasePeakel.class);
    private float area = 0.0f;
    private float apexIntensity = 0.0f;
    private float elutionTime;
    private float firstElutionTime;
    private float lastElutionTime;
    private int ms1Count = 0;
    private double mz;
    private IRawFile rawFile;
    private int msLevel;

    public BasePeakel(double mz, float elutionTime, float firstElutionTime, float lastElutionTime, IRawFile rawfile, int msLevel) {
        this.elutionTime = elutionTime;
        this.firstElutionTime = firstElutionTime;
        this.lastElutionTime = lastElutionTime;
        this.mz = mz;
        this.rawFile = rawfile;
        this.msLevel = msLevel;
    }

    @Override
    public float getArea() {
        return this.area;
    }

    public void setArea(float area) {
        this.area = area;
    }

    @Override
    public float getApexIntensity() {
        return this.apexIntensity;
    }

    public void setApexIntensity(float apexIntensity) {
        this.apexIntensity = apexIntensity;
    }

    @Override
    public float getElutionTime() {
        return this.elutionTime;
    }

    public void setElutionTime(float elutionTime) {
        this.elutionTime = elutionTime;
    }

    @Override
    public float getFirstElutionTime() {
        return this.firstElutionTime;
    }

    public void setFirstElutionTime(float firstElutionTime) {
        this.firstElutionTime = firstElutionTime;
    }

    @Override
    public float getLastElutionTime() {
        return this.lastElutionTime;
    }

    public void setLastElutionTime(float lastElutionTime) {
        this.lastElutionTime = lastElutionTime;
    }

    @Override
    public int getScanCount() {
        return this.ms1Count;
    }

    public void setMs1Count(int ms1Count) {
        this.ms1Count = ms1Count;
    }

    @Override
    public double getMz() {
        return this.mz;
    }

    public void setMz(double mz) {
        this.mz = mz;
    }

    @Override
    public float getDuration() {
        return this.lastElutionTime - this.firstElutionTime;
    }

    @Override
    public IRawFile getRawFile() {
        return this.rawFile;
    }

    @Override
    public void setRawFile(IRawFile rawfile) {
        this.rawFile = rawfile;
    }

    @Override
    public int getMsLevel() {
        return this.msLevel;
    }

    @Override
    public double getParentMz() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Peakel getPeakel() {
        return null;
    }
}

