/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class StatisticsTableModel
extends AbstractTableModel
implements ExtendedTableModelInterface {
    public static final int COLTYPE_TIME = 0;
    public static final int COLTYPE_METRIC = 1;
    private DescriptiveStatistics m_statistics;
    private String[] m_columnNames;
    private double[] m_time;
    private String m_modelName;
    private Color m_color;

    public StatisticsTableModel(String metricName, double[] time, DescriptiveStatistics statistics) {
        this.m_time = time;
        this.m_columnNames = new String[]{"time", metricName};
        this.m_statistics = statistics;
    }

    @Override
    public int getRowCount() {
        return this.m_time.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return this.m_columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.m_time[rowIndex];
            }
            case 1: {
                return this.m_statistics.getElement(rowIndex);
            }
        }
        return null;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return Double.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotColor(this.m_color);
        return plotInformation;
    }

    public void setColor(Color c) {
        this.m_color = c;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }
}

