/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.data;

import fr.proline.studio.python.data.ColBooleanData;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.IBinaryOperator;
import fr.proline.studio.python.data.IComparator;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.util.Conversion;
import java.util.ArrayList;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Col
extends PyObject {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    protected String m_columnName = null;
    protected String m_tooltip = null;
    protected Table m_table = null;

    public Col(Table table) {
        this.m_table = table;
    }

    public abstract Object getValueAt(int var1);

    public abstract void setValuetAt(int var1, Object var2);

    public abstract int getRowCount();

    public Table getTable() {
        return this.m_table;
    }

    public void setColumnName(String columnName) {
        this.m_columnName = columnName;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
    }

    public String getTooltip() {
        return this.m_tooltip;
    }

    public String getExportColumnName() {
        return this.m_columnName;
    }

    public abstract Col mutable();

    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyInteger) {
            Object o = this.getValueAt(((PyInteger)key).getValue());
            return Conversion.convertToPyObject(o);
        }
        throw Py.TypeError((String)("Unexpected Type Found " + key.getClass().getName()));
    }

    public void __setitem__(PyObject key, PyObject value) {
        if (key instanceof PyInteger) {
            this.setValuetAt(((PyInteger)key).getValue(), value);
            return;
        }
        throw Py.TypeError((String)("Unexpected Type Found " + key.getClass().getName()));
    }

    public int __len__() {
        return this.getRowCount();
    }

    public PyObject __add__(PyObject right) {
        return this.applyBinaryDoubleOp(this, right, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD + rightD;
            }
        });
    }

    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __pow__(PyObject right) {
        return this.applyBinaryDoubleOp(this, right, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return Math.pow(leftD, rightD);
            }
        });
    }

    public PyObject __rpow__(PyObject left) {
        return this.applyBinaryDoubleOp(left, this, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return Math.pow(leftD, rightD);
            }
        });
    }

    public PyObject __neg__() {
        return this.applyBinaryDoubleOp((PyObject)new PyInteger(0), this, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD - rightD;
            }
        });
    }

    public PyObject __sub__(PyObject right) {
        return this.applyBinaryDoubleOp(this, right, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD - rightD;
            }
        });
    }

    public PyObject __rsub__(PyObject left) {
        return this.applyBinaryDoubleOp(left, this, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD - rightD;
            }
        });
    }

    public PyObject __mul__(PyObject right) {
        return this.applyBinaryDoubleOp(this, right, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD * rightD;
            }
        });
    }

    public PyObject __rmul__(PyObject left) {
        return this.__mul__(left);
    }

    public PyObject __div__(PyObject right) {
        return this.applyBinaryDoubleOp(this, right, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD / rightD;
            }
        });
    }

    public PyObject __rdiv__(PyObject left) {
        return this.applyBinaryDoubleOp(left, this, new IBinaryOperator(){

            @Override
            public double compute(double leftD, double rightD) {
                return leftD / rightD;
            }
        });
    }

    public PyObject __gt__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD > rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return Boolean.FALSE;
            }
        });
    }

    public PyObject __ge__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD >= rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return Boolean.FALSE;
            }
        });
    }

    public PyObject __lt__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD < rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return Boolean.FALSE;
            }
        });
    }

    public PyObject __le__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD <= rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return Boolean.FALSE;
            }
        });
    }

    public PyObject __eq__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD == rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return o1 == null && o2 == null;
            }
        });
    }

    public PyObject __ne__(PyObject right) {
        return this.applyComparatorOp(this, right, new IComparator(){

            @Override
            public boolean compare(double leftD, double rightD) {
                return leftD != rightD;
            }

            @Override
            public boolean compareNullity(Object o1, Object o2) {
                return o1 != null || o2 != null;
            }
        });
    }

    public PyObject __invert__() {
        int nb = this.__len__();
        ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
        for (int i = 0; i < nb; ++i) {
            Object o = this.getValueAt(i);
            if (!(o instanceof Boolean)) {
                throw Py.TypeError((String)"Col with non boolean values");
            }
            boolean b = (Boolean)o == false;
            resultArray.add(b);
        }
        return new ColBooleanData(this.m_table, resultArray, null);
    }

    public PyObject __and__(PyObject right) {
        if (right instanceof ColBooleanData) {
            int nb = this.__len__();
            if (right.__len__() != nb) {
                throw Py.TypeError((String)"Tried to do 'and' with Columns with different sizes");
            }
            ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
            Col rightCol = (Col)right;
            for (int i = 0; i < nb; ++i) {
                Object o1 = this.getValueAt(i);
                Object o2 = rightCol.getValueAt(i);
                if (o1 == null || o2 == null) {
                    resultArray.add(Boolean.FALSE);
                    continue;
                }
                if (!(o1 instanceof Boolean) || !(o2 instanceof Boolean)) {
                    throw Py.TypeError((String)"Col with non boolean values");
                }
                boolean b = (Boolean)o1 != false && (Boolean)o2 != false;
                resultArray.add(b);
            }
            return new ColBooleanData(this.m_table, resultArray, null);
        }
        throw Py.TypeError((String)("Type Mismatch for + " + right.getClass().getName()));
    }

    public PyObject __or__(PyObject right) {
        if (right instanceof ColBooleanData) {
            int nb = this.__len__();
            if (right.__len__() != nb) {
                throw Py.TypeError((String)"Tried to do 'and' with Columns with different sizes");
            }
            ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
            Col rightCol = (Col)right;
            for (int i = 0; i < nb; ++i) {
                Object o1 = this.getValueAt(i);
                Object o2 = rightCol.getValueAt(i);
                if (o1 == null || o2 == null) {
                    if (o1 != null && o1 instanceof Boolean) {
                        resultArray.add((Boolean)o1);
                        continue;
                    }
                    if (o2 != null && o2 instanceof Boolean) {
                        resultArray.add((Boolean)o2);
                        continue;
                    }
                    resultArray.add(Boolean.FALSE);
                    continue;
                }
                if (!(o1 instanceof Boolean) || !(o2 instanceof Boolean)) {
                    throw Py.TypeError((String)"Col with non boolean values");
                }
                boolean b = (Boolean)o1 != false || (Boolean)o2 != false;
                resultArray.add(b);
            }
            return new ColBooleanData(this.m_table, resultArray, null);
        }
        throw Py.TypeError((String)("Type Mismatch for + " + right.getClass().getName()));
    }

    private PyObject applyComparatorOp(Col left, PyObject right, IComparator comparator) {
        int nb = left.__len__();
        if (right instanceof Col) {
            if (right.__len__() != nb) {
                throw Py.TypeError((String)"Tried to compare Columns with different sizes");
            }
            ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
            Col rightCol = (Col)right;
            for (int i = 0; i < nb; ++i) {
                boolean b;
                Object o1 = left.getValueAt(i);
                Object o2 = rightCol.getValueAt(i);
                if (o1 == null || o2 == null) {
                    b = comparator.compareNullity(o1, o2);
                    resultArray.add(b);
                    continue;
                }
                if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                b = comparator.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                resultArray.add(b);
            }
            return new ColBooleanData(this.m_table, resultArray, null);
        }
        if (right instanceof PyInteger) {
            int v = ((PyInteger)right).getValue();
            ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = left.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Boolean.FALSE);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                boolean b = comparator.compare(((Number)o1).doubleValue(), v);
                resultArray.add(b);
            }
            return new ColBooleanData(this.m_table, resultArray, null);
        }
        if (right instanceof PyFloat) {
            double v = ((PyFloat)right).getValue();
            ArrayList<Boolean> resultArray = new ArrayList<Boolean>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = left.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Boolean.FALSE);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                boolean b = comparator.compare(((Number)o1).doubleValue(), v);
                resultArray.add(b);
            }
            return new ColBooleanData(this.m_table, resultArray, null);
        }
        throw Py.TypeError((String)("Type Mismatch for + " + right.getClass().getName()));
    }

    private PyObject applyBinaryDoubleOp(PyObject left, PyObject right, IBinaryOperator operator) {
        if (right instanceof Col && left instanceof Col) {
            int nb = left.__len__();
            if (right.__len__() != nb) {
                throw Py.TypeError((String)"Tried to add Columns with different sizes");
            }
            ArrayList<Double> resultArray = new ArrayList<Double>(nb);
            Col rightCol = (Col)right;
            Col leftCol = (Col)left;
            for (int i = 0; i < nb; ++i) {
                Object o1 = leftCol.getValueAt(i);
                Object o2 = rightCol.getValueAt(i);
                if (o1 == null || o2 == null) {
                    resultArray.add(Double.NaN);
                    continue;
                }
                if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                double d = operator.compute(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                resultArray.add(d);
            }
            return new ColDoubleData(this.m_table, resultArray, null);
        }
        if (right instanceof PyInteger) {
            int v = ((PyInteger)right).getValue();
            int nb = left.__len__();
            Col leftCol = (Col)left;
            ArrayList<Double> resultArray = new ArrayList<Double>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = leftCol.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Double.NaN);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                double d = operator.compute(((Number)o1).doubleValue(), v);
                resultArray.add(d);
            }
            return new ColDoubleData(this.m_table, resultArray, null);
        }
        if (right instanceof PyFloat) {
            double v = ((PyFloat)right).getValue();
            int nb = left.__len__();
            Col leftCol = (Col)left;
            ArrayList<Double> resultArray = new ArrayList<Double>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = leftCol.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Double.NaN);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                double d = operator.compute(((Number)o1).doubleValue(), v);
                resultArray.add(d);
            }
            return new ColDoubleData(this.m_table, resultArray, null);
        }
        if (left instanceof PyInteger) {
            int v = ((PyInteger)left).getValue();
            int nb = right.__len__();
            Col rightCol = (Col)right;
            ArrayList<Double> resultArray = new ArrayList<Double>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = rightCol.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Double.NaN);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                double d = operator.compute(v, ((Number)o1).doubleValue());
                resultArray.add(d);
            }
            return new ColDoubleData(this.m_table, resultArray, null);
        }
        if (left instanceof PyFloat) {
            double v = ((PyFloat)left).getValue();
            int nb = right.__len__();
            Col rightCol = (Col)right;
            ArrayList<Double> resultArray = new ArrayList<Double>(nb);
            for (int i = 0; i < nb; ++i) {
                Object o1 = rightCol.getValueAt(i);
                if (o1 == null) {
                    resultArray.add(Double.NaN);
                    continue;
                }
                if (!(o1 instanceof Number)) {
                    throw Py.TypeError((String)"Col with non numeric values");
                }
                double d = operator.compute(v, ((Number)o1).doubleValue());
                resultArray.add(d);
            }
            return new ColDoubleData(this.m_table, resultArray, null);
        }
        throw Py.TypeError((String)("Type Mismatch for + " + right.getClass().getName()));
    }

    public abstract Class getColumnClass();
}

