/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.File;
import org.forester.archaeopteryx.Configuration;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.msa.Mafft;

public final class PhylogeneticInferenceOptions {
    private static final int BOOTSTRAP_RESAMPLES_DEFAULT = 100;
    private static final PairwiseDistanceCalculator.PWD_DISTANCE_METHOD PWD_DISTANCE_METHOD_DEFAULT = PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE;
    public static final long RANDOM_NUMBER_SEED_DEFAULT = 42L;
    private static final boolean PERFORM_BOOTSTRAP_RESAMPLING_DEFAULT = false;
    private static final double msa_processing_max_allowed_gap_ratio_default = 0.5;
    private static final int msa_processing_min_allowed_length_default = 50;
    private int _bootstrap_samples;
    private PairwiseDistanceCalculator.PWD_DISTANCE_METHOD _pwd_distance_method;
    private long _random_number_generator_seed;
    private boolean _perform_bootstrap_resampling;
    private String _intermediate_files_base;
    private String _msa_prg_parameters;
    private boolean _execute_msa_processing;
    private boolean _msa_processing_remove_all_gap_columns;
    private double _msa_processing_max_allowed_gap_ratio;
    private int _msa_processing_min_allowed_length;
    private boolean _save_pwd_file;
    private boolean _save_processed_msa;
    private boolean _save_original_msa;
    private File _pwd_outfile;
    private File _processed_msa_outfile;
    private File _original_msa_outfile;

    public synchronized String getMsaPrgParameters() {
        return this._msa_prg_parameters;
    }

    public synchronized void setMsaPrgParameters(String msa_prg_parameters) {
        this._msa_prg_parameters = new String(msa_prg_parameters);
    }

    public synchronized String getIntermediateFilesBase() {
        return this._intermediate_files_base;
    }

    public synchronized String getMsaPrg() {
        return "MAFFT";
    }

    public synchronized void setIntermediateFilesBase(String intermediate_files_base) {
        this._intermediate_files_base = new String(intermediate_files_base);
    }

    public PhylogeneticInferenceOptions() {
        this.init();
    }

    public synchronized PhylogeneticInferenceOptions copy() {
        PhylogeneticInferenceOptions o = new PhylogeneticInferenceOptions();
        o._bootstrap_samples = this._bootstrap_samples;
        o._pwd_distance_method = this._pwd_distance_method;
        o._random_number_generator_seed = this._random_number_generator_seed;
        o._perform_bootstrap_resampling = this._perform_bootstrap_resampling;
        o._intermediate_files_base = new String(this._intermediate_files_base);
        o._msa_prg_parameters = new String(this._msa_prg_parameters);
        o._msa_processing_max_allowed_gap_ratio = this._msa_processing_max_allowed_gap_ratio;
        o._msa_processing_min_allowed_length = this._msa_processing_min_allowed_length;
        o._execute_msa_processing = this._execute_msa_processing;
        o._msa_processing_remove_all_gap_columns = this._msa_processing_remove_all_gap_columns;
        o._save_pwd_file = this._save_pwd_file;
        o._save_processed_msa = this._save_processed_msa;
        o._save_original_msa = this._save_original_msa;
        if (this._pwd_outfile != null) {
            o._pwd_outfile = new File(this._pwd_outfile.toString());
        }
        if (this._processed_msa_outfile != null) {
            o._processed_msa_outfile = new File(this._processed_msa_outfile.toString());
        }
        if (this._original_msa_outfile != null) {
            o._original_msa_outfile = new File(this._original_msa_outfile.toString());
        }
        return o;
    }

    private synchronized void init() {
        this._bootstrap_samples = 100;
        this._pwd_distance_method = PWD_DISTANCE_METHOD_DEFAULT;
        this._random_number_generator_seed = 42L;
        this._perform_bootstrap_resampling = false;
        this._intermediate_files_base = "";
        this._msa_prg_parameters = Mafft.getDefaultParameters();
        this._msa_processing_max_allowed_gap_ratio = 0.5;
        this._msa_processing_min_allowed_length = 50;
        this._execute_msa_processing = false;
        this._msa_processing_remove_all_gap_columns = false;
        this._save_pwd_file = false;
        this._save_processed_msa = false;
        this._save_original_msa = false;
        this._pwd_outfile = null;
        this._processed_msa_outfile = null;
        this._original_msa_outfile = null;
    }

    public synchronized void setBootstrapSamples(int bootstrap_samples) {
        this._bootstrap_samples = bootstrap_samples;
    }

    public synchronized int getBootstrapSamples() {
        return this._bootstrap_samples;
    }

    public synchronized void setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD pwd_distance_method) {
        this._pwd_distance_method = pwd_distance_method;
    }

    public synchronized PairwiseDistanceCalculator.PWD_DISTANCE_METHOD getPwdDistanceMethod() {
        return this._pwd_distance_method;
    }

    public synchronized void setRandomNumberGeneratorSeed(long random_number_generator_seed) {
        this._random_number_generator_seed = random_number_generator_seed;
    }

    public synchronized long getRandomNumberGeneratorSeed() {
        return this._random_number_generator_seed;
    }

    public synchronized void setPerformBootstrapResampling(boolean perform_bootstrap_resampling) {
        this._perform_bootstrap_resampling = perform_bootstrap_resampling;
    }

    public synchronized boolean isPerformBootstrapResampling() {
        return this._perform_bootstrap_resampling;
    }

    public static PhylogeneticInferenceOptions createInstance(Configuration configuration) {
        PhylogeneticInferenceOptions o = new PhylogeneticInferenceOptions();
        if (configuration.getDefaultBootstrapSamples() >= 0) {
            o.setBootstrapSamples(configuration.getDefaultBootstrapSamples());
        }
        return o;
    }

    public File getTempDir() {
        return new File("/Users/zma/Desktop/tmp/");
    }

    public void setMsaProcessingMaxAllowedGapRatio(double msa_processing_max_allowed_gap_ratio) {
        this._msa_processing_max_allowed_gap_ratio = msa_processing_max_allowed_gap_ratio;
    }

    public double getMsaProcessingMaxAllowedGapRatio() {
        return this._msa_processing_max_allowed_gap_ratio;
    }

    public void setMsaProcessingMinAllowedLength(int msa_processing_min_allowed_length) {
        this._msa_processing_min_allowed_length = msa_processing_min_allowed_length;
    }

    public int getMsaProcessingMinAllowedLength() {
        return this._msa_processing_min_allowed_length;
    }

    boolean isExecuteMsaProcessing() {
        return this._execute_msa_processing;
    }

    void setExecuteMsaProcessing(boolean execute_msa_processing) {
        this._execute_msa_processing = execute_msa_processing;
    }

    boolean isMsaProcessingRemoveAllGapColumns() {
        return this._msa_processing_remove_all_gap_columns;
    }

    void setMsaProcessingRemoveAllGapColumns(boolean msa_processing_remove_all_gap_columns) {
        this._msa_processing_remove_all_gap_columns = msa_processing_remove_all_gap_columns;
    }

    boolean isSavePwdFile() {
        return this._save_pwd_file;
    }

    void setSavePwdFile(boolean save_pwd_file) {
        this._save_pwd_file = save_pwd_file;
    }

    boolean isSaveProcessedMsa() {
        return this._save_processed_msa;
    }

    void setSaveProcessedMsa(boolean save_processed_msa) {
        this._save_processed_msa = save_processed_msa;
    }

    boolean isSaveOriginalMsa() {
        return this._save_original_msa;
    }

    void setSaveOriginalMsa(boolean save_original_msa) {
        this._save_original_msa = save_original_msa;
    }

    File getPwdOutfile() {
        return this._pwd_outfile;
    }

    void setPwdOutfile(File pwd_outfile) {
        this._pwd_outfile = pwd_outfile;
    }

    File getProcesseMsaOutfile() {
        return this._processed_msa_outfile;
    }

    void setProcesseMsaOutfile(File processed_msa_outfile) {
        this._processed_msa_outfile = processed_msa_outfile;
    }

    File getOriginalMsaOutfile() {
        return this._original_msa_outfile;
    }

    void setOriginalMsaOutfile(File original_msa_outfile) {
        this._original_msa_outfile = original_msa_outfile;
    }
}

