/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoRelationship;
import org.forester.go.GoSubset;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public class BasicGoTerm
implements GoTerm {
    private final GoId _id;
    private final String _name;
    private final boolean _is_obsolete;
    private final GoNameSpace _namespace;
    private String _definition;
    private List<GoId> _alt_ids;
    private List<GoId> _super_go_ids;
    private List<GoXRef> _go_xrefs;
    private List<GoSubset> _go_subsets;
    private String _comment;
    private List<GoRelationship> _go_relationships;

    public BasicGoTerm(GoId id, String name, GoNameSpace namespace, boolean is_obsolete) {
        if (id == null || ForesterUtil.isEmpty(name) || namespace == null) {
            throw new IllegalArgumentException("attempt to create GO term with empty id, name, or namespace");
        }
        this._id = id;
        this._name = name;
        this._namespace = namespace;
        this._is_obsolete = is_obsolete;
        this.init();
    }

    public BasicGoTerm(String id, String name, String namespace, boolean is_obsolete) {
        if (ForesterUtil.isEmpty(id) || ForesterUtil.isEmpty(name) || ForesterUtil.isEmpty(namespace)) {
            throw new IllegalArgumentException("attempt to create GO term with empty id, name, or namespace");
        }
        this._id = new GoId(id);
        this._name = name;
        this._namespace = new GoNameSpace(namespace);
        this._is_obsolete = is_obsolete;
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getGoId().toString());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.toString());
    }

    @Override
    public int compareTo(GoTerm go_term) {
        return this.getGoId().compareTo(go_term.getGoId());
    }

    @Override
    public PhylogenyData copy() {
        BasicGoTerm gt = new BasicGoTerm(this.getGoId(), this.getName(), this.getGoNameSpace(), this.isObsolete());
        gt.setGoXrefs(this.getGoXRefs());
        gt.setGoSubsets(this.getGoSubsets());
        gt.setSuperTerms(this.getSuperGoIds());
        gt.setAltIds(this.getAltIds());
        gt.setDefinition(this.getDefinition());
        return gt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go term equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go term equality to " + o + " [" + o.getClass() + "]");
        }
        GoTerm gt = (GoTerm)o;
        return this.getGoNameSpace().equals(gt.getGoNameSpace()) && this.getGoId().equals(gt.getGoId());
    }

    @Override
    public List<GoId> getAltIds() {
        return this._alt_ids;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public String getDefinition() {
        return this._definition;
    }

    @Override
    public GoId getGoId() {
        return this._id;
    }

    @Override
    public GoNameSpace getGoNameSpace() {
        return this._namespace;
    }

    @Override
    public List<GoRelationship> getGoRelationships() {
        return this._go_relationships;
    }

    @Override
    public List<GoSubset> getGoSubsets() {
        return this._go_subsets;
    }

    @Override
    public List<GoXRef> getGoXRefs() {
        return this._go_xrefs;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public List<GoId> getSuperGoIds() {
        return this._super_go_ids;
    }

    public int hashCode() {
        return this.getGoId().hashCode();
    }

    private void init() {
        this.setGoXrefs(new ArrayList<GoXRef>());
        this.setSuperTerms(new ArrayList<GoId>());
        this.setAltIds(new ArrayList<GoId>());
        this.setGoRelationships(new ArrayList<GoRelationship>());
        this.setGoSubsets(new ArrayList<GoSubset>());
        this.setDefinition("");
        this.setComment("");
    }

    @Override
    public boolean isEqual(PhylogenyData go_term) {
        return this.equals(go_term);
    }

    @Override
    public boolean isObsolete() {
        return this._is_obsolete;
    }

    private void setAltIds(List<GoId> alt_ids) {
        this._alt_ids = alt_ids;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setDefinition(String definition) {
        this._definition = definition;
    }

    private void setGoRelationships(List<GoRelationship> go_relationships) {
        this._go_relationships = go_relationships;
    }

    public void setGoSubsets(List<GoSubset> go_subsets) {
        this._go_subsets = go_subsets;
    }

    private void setGoXrefs(List<GoXRef> xrefs) {
        this._go_xrefs = xrefs;
    }

    private void setSuperTerms(List<GoId> super_terms) {
        this._super_go_ids = super_terms;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getGoId());
        sb.append(": ");
        sb.append(this.getName());
        sb.append(" [");
        sb.append(this.getGoNameSpace());
        sb.append("]");
        if (this.isObsolete()) {
            sb.append(" [is obsolete]");
        }
        return sb.toString();
    }
}

