/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.provider;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.RunSliceData;
import java.io.StreamCorruptedException;
import java.util.Iterator;

public class RunSliceDataProvider {
    MzDbReader mzDBInstance;
    Iterator<RunSlice> rsdIter;

    public RunSliceDataProvider(Iterator<RunSlice> rsdIter) {
        this.rsdIter = rsdIter;
    }

    public RunSliceData getRunSliceData(int runSliceNumber) throws SQLiteException, StreamCorruptedException {
        RunSliceData data = this._getNextMatchingRunSliceData(runSliceNumber);
        if (data == null) {
            System.out.println("Non optimal run slice data fetching");
            return this.mzDBInstance.getRunSliceData(runSliceNumber);
        }
        return data;
    }

    private RunSliceData _getNextMatchingRunSliceData(int runSliceNumber) throws SQLiteException {
        while (this.rsdIter.hasNext()) {
            RunSlice tmpRs = this.rsdIter.next();
            int curRsNumber = tmpRs.getHeader().getNumber();
            if (curRsNumber == runSliceNumber) {
                return tmpRs.getData();
            }
            if (curRsNumber <= runSliceNumber) continue;
            return null;
        }
        return null;
    }
}

