/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.exporter;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.model.Feature;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SQLiteFeatureStorer$ {
    public static final SQLiteFeatureStorer$ MODULE$;

    static {
        new SQLiteFeatureStorer$();
    }

    public void storeFeatures(Seq<Feature> features, File dbLocation) {
        SQLiteConnection connection = new SQLiteConnection(dbLocation);
        Object object = dbLocation.exists() ? BoxesRunTime.boxToBoolean((boolean)dbLocation.delete()) : BoxedUnit.UNIT;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"nb features:").append((Object)BoxesRunTime.boxToInteger((int)features.length())).toString());
        connection.open(true);
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=8000;");
        connection.exec("CREATE TABLE feature ( id INTEGER,\n charge INTEGER,\n mz REAL,\n time REAL,\n area REAL,\n sum_intensity_top_2 REAL,\n ms1_count INTEGER,\n isotopes_count INTEGER,\n xic_1 BLOB,\n xic_2 BLOB,\n xic_3 BLOB,\n xic_4 BLOB,\n xic_5 BLOB,\n xic_6 BLOB)");
        connection.exec("BEGIN TRANSACTION");
        SQLiteStatement stmt = connection.prepare("INSERT INTO feature VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", true);
        ((IterableLike)features.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Feature x$3) {
                return x$3.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(stmt){
            public static final long serialVersionUID = 0L;
            private final SQLiteStatement stmt$3;

            public final SQLiteStatement apply(Feature ft) {
                byte[][] charts = new byte[6][];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(this, charts, ft){
                    public static final long serialVersionUID = 0L;
                    private final byte[][] charts$1;
                    private final Feature ft$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.charts$1[i] = i < this.ft$1.getPeakelsCount() ? SQLiteFeatureStorer$.MODULE$.createFeatureChart(this.ft$1.getXIC(i)) : SQLiteFeatureStorer$.MODULE$.createFeatureChart((Tuple2<float[], float[]>)new Tuple2(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Float()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Float())));
                    }
                    {
                        this.charts$1 = charts$1;
                        this.ft$1 = ft$1;
                    }
                });
                int j = 0;
                this.stmt$3.bind(++j, ft.id());
                this.stmt$3.bind(++j, ft.charge());
                this.stmt$3.bind(++j, ft.mz());
                this.stmt$3.bind(++j, (double)ft.getElutionTime());
                this.stmt$3.bind(++j, (double)ft.area());
                this.stmt$3.bind(++j, (double)(ft.getPeakel(0).getApexIntensity() + ft.getPeakel(1).getApexIntensity()));
                this.stmt$3.bind(++j, ft.getMs1Count());
                this.stmt$3.bind(++j, ft.getPeakelsCount());
                this.stmt$3.bind(++j, charts[0]);
                this.stmt$3.bind(++j, charts[1]);
                this.stmt$3.bind(++j, charts[2]);
                this.stmt$3.bind(++j, charts[3]);
                this.stmt$3.bind(++j, charts[4]);
                this.stmt$3.bind(++j, charts[5]);
                this.stmt$3.step();
                return this.stmt$3.reset();
            }
            {
                this.stmt$3 = stmt$3;
            }
        });
        connection.exec("COMMIT TRANSACTION");
        connection.dispose();
    }

    public byte[] createFeatureChart(Tuple2<float[], float[]> xic) {
        XYSeries series = new XYSeries((Comparable)((Object)"XIC"));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.floatArrayOps((float[])xic._1()).zip((GenIterable)Predef$.MODULE$.wrapFloatArray((float[])xic._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(series){
            public static final long serialVersionUID = 0L;
            private final XYSeries series$3;

            public final void apply(Tuple2<Object, Object> dataPoint) {
                this.series$3.add((double)(BoxesRunTime.unboxToFloat((Object)dataPoint._1()) / (float)60), (double)BoxesRunTime.unboxToFloat((Object)dataPoint._2()));
            }
            {
                this.series$3 = series$3;
            }
        });
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Feature XIC", (String)"Time", (String)"Intensity", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BufferedImage bi = this.chartToImage(chart, 400, 300);
        return ChartUtilities.encodeAsPNG((BufferedImage)bi);
    }

    public BufferedImage chartToImage(JFreeChart chart, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.dispose();
        return img;
    }

    private SQLiteFeatureStorer$() {
        MODULE$ = this;
    }
}

