/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.msfiles.WorkingSet;
import fr.proline.studio.msfiles.WorkingSetEntry;
import fr.proline.studio.msfiles.WorkingSetRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WorkingSetModel
implements TreeModel {
    private final DefaultMutableTreeNode m_root;
    private final HashSet<TreeModelListener> m_listeners;
    private final HashMap<String, ArrayList<WorkingSet>> m_index;
    private final HashMap<String, JSONObject> m_setsObjects;
    private final HashMap<String, JSONObject> m_entriesObjects;
    private boolean m_displayFilename;

    public WorkingSetModel(WorkingSetRoot root) {
        this.m_root = new DefaultMutableTreeNode(root);
        this.m_listeners = new HashSet();
        this.m_displayFilename = NbPreferences.root().get("MsFiles.WsEntryLabel", "Filename").equalsIgnoreCase("Filename");
        this.m_index = new HashMap();
        this.m_setsObjects = new HashMap();
        this.m_entriesObjects = new HashMap();
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
        Object userObject = parentNode.getUserObject();
        if (userObject instanceof WorkingSetRoot) {
            WorkingSetRoot workingSetRoot = (WorkingSetRoot)userObject;
            JSONObject workingSetEntry = (JSONObject)workingSetRoot.getWorkingSets().get(index);
            String name = (String)workingSetEntry.get((Object)"name");
            String description = (String)workingSetEntry.get((Object)"description");
            JSONArray entries = (JSONArray)workingSetEntry.get((Object)"entries");
            WorkingSet newWorkingSet = new WorkingSet(name, description, entries);
            this.m_setsObjects.put(name, workingSetEntry);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newWorkingSet);
            parentNode.add(childNode);
            return childNode;
        }
        if (userObject instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)userObject;
            JSONObject entryObject = (JSONObject)workingSet.getEntries().get(index);
            String filename = (String)entryObject.get((Object)"filename");
            String stringLocation = (String)entryObject.get((Object)"location");
            WorkingSetEntry.Location location = null;
            if (stringLocation.equalsIgnoreCase("LOCAL")) {
                location = WorkingSetEntry.Location.LOCAL;
            } else if (stringLocation.equalsIgnoreCase("REMOTE")) {
                location = WorkingSetEntry.Location.REMOTE;
            }
            String path = (String)entryObject.get((Object)"path");
            WorkingSetEntry newEntry = new WorkingSetEntry(filename, path, location, workingSet, this.m_displayFilename ? WorkingSetEntry.Labeling.DISPLAY_FILENAME : WorkingSetEntry.Labeling.DISPLAY_PATH);
            this.m_entriesObjects.put(path, entryObject);
            if (this.m_index.containsKey(path)) {
                this.m_index.get(path).add(workingSet);
            } else {
                ArrayList<WorkingSet> list = new ArrayList<WorkingSet>();
                list.add(workingSet);
                this.m_index.put(path, list);
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newEntry);
            parentNode.add(childNode);
            return childNode;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
        Object userObject = parentNode.getUserObject();
        if (userObject instanceof WorkingSet) {
            return ((WorkingSet)userObject).getEntries().size();
        }
        if (userObject instanceof WorkingSetRoot) {
            return ((WorkingSetRoot)userObject).getWorkingSets().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
        Object userObject = mutableNode.getUserObject();
        return userObject instanceof WorkingSetEntry;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        block3: {
            Object childObject;
            Object parentObject;
            block2: {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)child;
                parentObject = parentNode.getUserObject();
                childObject = childNode.getUserObject();
                if (!(parentObject instanceof WorkingSetRoot)) break block2;
                WorkingSetRoot root = (WorkingSetRoot)parentObject;
                WorkingSet childWorkingSet = (WorkingSet)childObject;
                JSONArray workingSets = root.getWorkingSets();
                for (int i = 0; i < workingSets.size(); ++i) {
                    JSONObject innerObj = (JSONObject)workingSets.get(i);
                    String innerObjName = (String)innerObj.get((Object)"name");
                    if (!innerObjName.equalsIgnoreCase(childWorkingSet.getName())) continue;
                    return i;
                }
                break block3;
            }
            if (!(parentObject instanceof WorkingSet)) break block3;
            WorkingSet workingSet = (WorkingSet)parentObject;
            WorkingSetEntry workingSetEntry = (WorkingSetEntry)childObject;
            JSONArray entries = workingSet.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject innerObj = (JSONObject)entries.get(i);
                String innerObjPath = (String)innerObj.get((Object)"path");
                if (!innerObjPath.equalsIgnoreCase(workingSetEntry.getPath())) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.m_listeners.remove(l);
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.m_listeners) {
            listener.treeNodesInserted(e);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.m_listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.m_listeners) {
            listener.treeNodesChanged(e);
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.m_listeners) {
            listener.treeStructureChanged(e);
        }
    }

    public HashMap<String, ArrayList<WorkingSet>> getAssociationsIndex() {
        return this.m_index;
    }

    public void updateJSONObject(JSONObjectType type, String key, String objectKey, String objectNewValue) {
        JSONObject entry;
        if (type == JSONObjectType.WORKING_SET) {
            JSONObject workingSet = this.m_setsObjects.get(key);
            if (workingSet != null) {
                workingSet.put((Object)objectKey, (Object)objectNewValue);
            }
        } else if (type == JSONObjectType.ENTRY && (entry = this.m_entriesObjects.get(key)) != null) {
            entry.put((Object)objectKey, (Object)objectNewValue);
        }
    }

    public HashMap<String, JSONObject> getEntiesObjects() {
        return this.m_entriesObjects;
    }

    public HashMap<String, JSONObject> getSetsObjects() {
        return this.m_setsObjects;
    }

    public static enum JSONObjectType {
        WORKING_SET,
        ENTRY;

    }
}

