/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WorkingSetRoot {
    private final JSONArray m_workingSets;
    private final HashSet<String> m_index;

    public WorkingSetRoot(JSONArray workingSets) {
        this.m_workingSets = workingSets;
        this.m_index = new HashSet();
        this.updateIndex();
    }

    public JSONArray getWorkingSets() {
        return this.m_workingSets;
    }

    public String toString() {
        return "Home";
    }

    public boolean removeWorkingSet(String name) {
        for (int i = 0; i < this.m_workingSets.size(); ++i) {
            JSONObject innerObj = (JSONObject)this.m_workingSets.get(i);
            String currentName = (String)innerObj.get((Object)"name");
            if (!name.equalsIgnoreCase(currentName)) continue;
            this.m_workingSets.remove(i);
            this.m_index.remove(currentName);
            return true;
        }
        return false;
    }

    public boolean addWorkingset(String name, String description) {
        if (!this.m_index.contains(name)) {
            JSONObject newWorkingSet = new JSONObject();
            newWorkingSet.put((Object)"name", (Object)name);
            newWorkingSet.put((Object)"description", (Object)description);
            newWorkingSet.put((Object)"entries", (Object)new JSONArray());
            this.m_index.add(name);
            this.m_workingSets.add((Object)newWorkingSet);
            return true;
        }
        return false;
    }

    private void updateIndex() {
        for (int i = 0; i < this.m_workingSets.size(); ++i) {
            JSONObject workingSetEntry = (JSONObject)this.m_workingSets.get(i);
            String name = (String)workingSetEntry.get((Object)"name");
            this.m_index.add(name);
        }
    }
}

