/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.rsmexplorer.gui.GraphicsPanel;

public class DataboxGraphics
extends AbstractDataBox {
    private ExtendedTableModelInterface m_values = null;
    private boolean m_defaultLocked = false;

    public DataboxGraphics() {
        this(true);
    }

    public DataboxGraphics(boolean defaultLocked) {
        super(AbstractDataBox.DataboxType.DataboxGraphics, AbstractDataBox.DataboxStyle.STYLE_UNKNOWN);
        this.m_defaultLocked = defaultLocked;
        this.m_typeName = "Customisable Graphical Display";
        this.m_description = "Plots data as Histogram / Scatter Plot / Venn Diagram / Parallel Coordinates";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ExtendedTableModelInterface.class, false);
        this.registerInParameter(inParameter);
    }

    protected void setDefaultLocked(boolean defaultLocked) {
        this.m_defaultLocked = defaultLocked;
    }

    protected boolean isDefaultLocked() {
        return this.m_defaultLocked;
    }

    @Override
    public void createPanel() {
        GraphicsPanel p = new GraphicsPanel(this.m_defaultLocked);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        ExtendedTableModelInterface values = this.m_values != null ? this.m_values : (ExtendedTableModelInterface)this.getData(ExtendedTableModelInterface.class);
        CrossSelectionInterface crossSelectionInterface = this.m_values != null ? null : (CrossSelectionInterface)this.getData(CrossSelectionInterface.class);
        ((GraphicsPanel)this.getDataBoxPanelInterface()).setData(values, crossSelectionInterface);
    }

    @Override
    public void setEntryData(Object data) {
        this.m_values = (ExtendedTableModelInterface)data;
        this.dataChanged();
    }
}

