/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.ExperimentalDesignPanel;

public class DataboxExperimentalDesign
extends AbstractDataBox {
    private DDataset m_dataset;

    public DataboxExperimentalDesign() {
        super(AbstractDataBox.DataboxType.DataboxExperimentalDesign, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Experimental Design";
        this.m_description = "Experimental Design of the quantitation";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DDataset.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        ExperimentalDesignPanel p = new ExperimentalDesignPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    ((ExperimentalDesignPanel)DataboxExperimentalDesign.this.getDataBoxPanelInterface()).setData(taskId, DataboxExperimentalDesign.this.m_dataset, finished);
                } else {
                    ((ExperimentalDesignPanel)DataboxExperimentalDesign.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxExperimentalDesign.this.setLoaded(loadingId);
                if (finished) {
                    DataboxExperimentalDesign.this.unregisterTask(taskId);
                    DataboxExperimentalDesign.this.addDataChanged(DDataset.class);
                    DataboxExperimentalDesign.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadQuantChannels(this.getProjectId(), this.m_dataset);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA && parameterType.equals(DDataset.class)) {
            return this.m_dataset;
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }
}

