/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;

public abstract class AbstractDisplayPTMDataAction
extends AbstractRSMAction {
    private boolean m_dataIsPTMSite;
    private boolean m_isAnnotatedPTMs;

    public AbstractDisplayPTMDataAction(boolean isSite, AbstractTree tree) {
        this(isSite, false, tree);
    }

    public AbstractDisplayPTMDataAction(boolean isSite, boolean isAnnotatedPTMDs, AbstractTree tree) {
        super(isSite ? (isAnnotatedPTMDs ? "Annotated Sites" : "Sites") : (isAnnotatedPTMDs ? "Annotated Clusters" : "Clusters"), tree);
        this.m_dataIsPTMSite = isSite;
        this.m_isAnnotatedPTMs = isAnnotatedPTMDs;
    }

    public AbstractDisplayPTMDataAction(boolean isSite, boolean isAnnotatedPTMDs, AbstractTree tree, String prefix) {
        super(isSite ? (isAnnotatedPTMDs ? prefix + " Annotated Sites" : prefix + " Sites") : (isAnnotatedPTMDs ? prefix + " Annotated Clusters" : prefix + " Clusters"), tree);
        this.m_dataIsPTMSite = isSite;
        this.m_isAnnotatedPTMs = isAnnotatedPTMDs;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode);
        }
    }

    protected boolean isAnnotatedPTMsAction() {
        return this.m_isAnnotatedPTMs;
    }

    protected abstract void loadWindowBox(DDataset var1, Object var2, boolean var3);

    protected void actionImpl(DataSetNode dataSetNode) {
        final DDataset dataSet = ((DataSetData)dataSetNode.getData()).getDataset();
        if (!dataSetNode.hasResultSummary()) {
            return;
        }
        PTMDataset ptmDataset = null;
        boolean unsaved = false;
        if (this.m_isAnnotatedPTMs) {
            if (DatabaseDataManager.getDatabaseDataManager().getAnnotatedPTMDatasetSetForDS(Long.valueOf(dataSet.getId())) != null) {
                unsaved = DatabaseDataManager.getDatabaseDataManager().getAnnotatedPTMDatasetSetForDS(Long.valueOf(dataSet.getId())).shouldSavePTMDataset();
            }
            ptmDataset = this.m_dataIsPTMSite ? DatabaseDataManager.getDatabaseDataManager().getAnnotatedSitesPTMDatasetForDS(Long.valueOf(dataSet.getId())) : DatabaseDataManager.getDatabaseDataManager().getAnnotatedClustersPTMDatasetForDS(Long.valueOf(dataSet.getId()));
        } else {
            PTMDataset pTMDataset = ptmDataset = this.m_dataIsPTMSite ? DatabaseDataManager.getDatabaseDataManager().getSitesPTMDatasetForDS(Long.valueOf(dataSet.getId())) : DatabaseDataManager.getDatabaseDataManager().getClustersPTMDatasetForDS(Long.valueOf(dataSet.getId()));
        }
        if (ptmDataset != null) {
            this.loadWindowBox(dataSet, ptmDataset, unsaved);
        } else {
            ResultSummary rsm = dataSetNode.getResultSummary();
            if (rsm != null) {
                this.loadWindowBox(dataSet, dataSet, unsaved);
            } else {
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        AbstractDisplayPTMDataAction.this.loadWindowBox(dataSet, dataSet, false);
                    }
                };
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initLoadRsetAndRsm(dataSet);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes == 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

