/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.studio.WindowManager;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.ManageSaveWindowsDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import java.awt.Window;
import java.util.ArrayList;

public class ManageUserWindowsAction
extends AbstractRSMAction {
    private char m_windowType;

    public ManageUserWindowsAction(char saveWindowType, AbstractTree tree) {
        super("Manage User Windows...", tree);
        this.m_windowType = saveWindowType;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        ManageSaveWindowsDialog dialog = ManageSaveWindowsDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private boolean isForRSM() {
        return this.m_windowType == '2';
    }

    private boolean isForRset() {
        return this.m_windowType == '1';
    }

    private boolean isForQuanti() {
        return this.m_windowType == '3';
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        boolean enable = false;
        ArrayList<String> savedWindowsList = WindowSavedManager.readSavedWindows();
        int nb = savedWindowsList.size();
        for (int i = 0; i < nb; ++i) {
            String wndSaved = savedWindowsList.get(i);
            if (this.isForRSM() && WindowSavedManager.hasResultSummaryParameter(wndSaved)) {
                enable = true;
                break;
            }
            if (this.isForRset() && WindowSavedManager.hasResultSetParameter(wndSaved)) {
                enable = true;
                break;
            }
            if (!this.isForQuanti() || !WindowSavedManager.hasQuantiParameter(wndSaved)) continue;
            enable = true;
            break;
        }
        this.setEnabled(enable);
    }
}

