/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.studio.dam.tasks.data.AdjacencyMatrixData;
import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.ConnectedComponents;
import java.util.ArrayList;
import java.util.HashMap;

public class DrawVisualization {
    private AdjacencyMatrixData m_adjacencyMatrixData = null;
    private ArrayList<Component> m_cList;
    private ConnectedComponents m_cObject;

    public void setData(AdjacencyMatrixData adjacencyMatrixData, boolean keepSameSet) {
        this.m_adjacencyMatrixData = adjacencyMatrixData;
        this.m_cObject = new ConnectedComponents(this.getProtineList(), this.getPeptideList(), this.getProteinToPeptideMap(), this.getPeptideToProteinMap(), this.getEquivalentProteins());
        this.m_cList = this.m_cObject.getConnectedComponents(keepSameSet);
    }

    public int getLargestComponent() {
        int maxIndex = this.m_cObject.getLargestComponent();
        return maxIndex;
    }

    public ArrayList<Component> getComponentList() {
        return this.m_cList;
    }

    private ArrayList<LightProteinMatch> getProtineList() {
        return this.m_adjacencyMatrixData.getProtineList();
    }

    private ArrayList<LightPeptideMatch> getPeptideList() {
        return this.m_adjacencyMatrixData.getPeptideList();
    }

    public HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> getProteinToPeptideMap() {
        return this.m_adjacencyMatrixData.getProteinToPeptideMap();
    }

    public HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> getPeptideToProteinMap() {
        return this.m_adjacencyMatrixData.getPeptideToProteinMap();
    }

    public HashMap<LightProteinMatch, ArrayList<LightProteinMatch>> getEquivalentProteins() {
        return this.m_adjacencyMatrixData.getEquivalentProteins();
    }

    public HashMap<LightProteinMatch, LightProteinMatch> getEquivalentToMainProtein() {
        return this.m_adjacencyMatrixData.getEquivalentToMainProtein();
    }
}

