/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.ModifyClusterStatusPanel;
import fr.proline.studio.rsmexplorer.gui.model.PTMPeptidesTableModel;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditClusterDialog
extends DefaultDialog {
    private static final Logger LOG = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    private PTMCluster m_editedCluster;
    private List<PTMPeptideInstance> m_ptmPeptideInstances;
    private List<PTMPeptideInstance> m_removedPeptideInstances;
    private ModifyClusterStatusPanel m_statusPanel;
    private JScrollPane m_ptmPeptidesScrollPane;
    private PTMPeptidesTable m_ptmPeptidesTable;
    private PTMPeptidesTableModel m_ptmPeptidesTableModel;
    private boolean m_peptidesDeleted;
    private boolean m_statusModified;

    public EditClusterDialog(PTMCluster cluster) {
        super((Window)WindowManager.getDefault().getMainWindow());
        this.setTitle("Edit Cluster " + cluster.getId() + " [" + cluster.getProteinMatch().getAccession() + " / " + cluster.getRepresentativePepMatch().getPeptide().getSequence() + "]");
        this.setResizable(true);
        StringBuilder helpTextBuilder = new StringBuilder(StudioResourceBundle.getMessage(EditClusterDialog.class, (String)"EditCluster.status.modif.html.help"));
        helpTextBuilder.append("<br><br>").append(StudioResourceBundle.getMessage(EditClusterDialog.class, (String)"EditCluster.peptide.remove.html.help"));
        this.setHelpHeader(IconManager.getIcon((IconManager.IconType)IconManager.IconType.INFORMATION), "Edit Cluster", helpTextBuilder.toString());
        this.m_editedCluster = cluster;
        this.m_ptmPeptideInstances = new ArrayList<PTMPeptideInstance>(cluster.getParentPTMPeptideInstances());
        this.initComponent();
        this.m_statusPanel.setData(this.m_editedCluster);
        this.m_ptmPeptidesTable.setData(this.m_ptmPeptideInstances);
        this.m_removedPeptideInstances = new ArrayList<PTMPeptideInstance>();
    }

    private void initComponent() {
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JSplitPane sp = new JSplitPane(0);
        sp.setResizeWeight(0.5);
        this.m_statusPanel = new ModifyClusterStatusPanel();
        this.m_statusPanel.setBorder(new TitledBorder(" Cluster Status "));
        sp.setTopComponent(this.m_statusPanel);
        JPanel peptidePanel = this.createCLusterPeptidesPanel();
        sp.setBottomComponent(peptidePanel);
        c.weightx = 1.0;
        c.weighty = 1.0;
        editPanel.add((Component)sp, c);
        this.setInternalComponent(editPanel);
    }

    private JPanel createCLusterPeptidesPanel() {
        JPanel peptidePanel = new JPanel();
        peptidePanel.setBorder(new TitledBorder(" Cluster Peptides "));
        peptidePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        JButton removePeptideButton = new JButton();
        removePeptideButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CANCEL));
        removePeptideButton.setToolTipText("Remove selected Peptides from Cluster");
        removePeptideButton.addActionListener(e -> {
            if (this.m_ptmPeptidesTable.getSelectedRowCount() == 1) {
                this.removeSelectedPeptide();
            } else {
                InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.INFO, "Remove Peptide", "At least one, and only one, peptide should be selected.");
                err.setButtonVisible(1, false);
                err.setButtonName(0, "OK");
                err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                err.setVisible(true);
            }
        });
        toolbar.add(removePeptideButton);
        JPanel ptmPeptidesPanel = this.createPtmPeptidesPanel();
        peptidePanel.add((Component)toolbar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        peptidePanel.add((Component)ptmPeptidesPanel, c);
        return peptidePanel;
    }

    private JPanel createPtmPeptidesPanel() {
        JPanel ptmPeptidesPanel = new JPanel();
        ptmPeptidesPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_ptmPeptidesScrollPane = new JScrollPane();
        this.m_ptmPeptidesTable = new PTMPeptidesTable();
        this.m_ptmPeptidesTableModel = new PTMPeptidesTableModel(this.m_ptmPeptidesTable, false, false);
        this.m_ptmPeptidesTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)this.m_ptmPeptidesTableModel, true));
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.m_ptmPeptidesTable.getModel());
        this.m_ptmPeptidesTable.setRowSorter(sorter);
        this.m_ptmPeptidesScrollPane.setViewportView((Component)((Object)this.m_ptmPeptidesTable));
        this.m_ptmPeptidesTable.setFillsViewportHeight(true);
        this.m_ptmPeptidesTable.setViewport(this.m_ptmPeptidesScrollPane.getViewport());
        ptmPeptidesPanel.add((Component)this.m_ptmPeptidesScrollPane, c);
        return ptmPeptidesPanel;
    }

    private void removeSelectedPeptide() {
        ArrayList<PTMCluster> clusters = new ArrayList<PTMCluster>();
        clusters.add(this.m_editedCluster);
        PTMPeptideInstance ptmPep = this.getSelectedPTMPeptideInstance();
        DPeptideMatch repPepMatch = ptmPep.getRepresentativePepMatch(clusters);
        DPeptideMatch clusterPepMatch = this.m_editedCluster.getRepresentativePepMatch();
        if (repPepMatch != null && clusterPepMatch.getId() == repPepMatch.getId()) {
            InfoDialog id = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Remove Peptide Error", "Can not remove representative peptide from cluster");
            id.setButtonName(0, "OK");
            id.setButtonVisible(1, false);
            id.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
            id.setVisible(true);
            return;
        }
        this.m_removedPeptideInstances.add(ptmPep);
        this.m_ptmPeptideInstances.remove(ptmPep);
        this.m_peptidesDeleted = true;
        this.m_ptmPeptidesTable.setData(this.m_ptmPeptideInstances);
        LOG.debug(" DELETE ptm peptide " + ptmPep.getPeptideInstance().getId());
    }

    private PTMPeptideInstance getSelectedPTMPeptideInstance() {
        if (this.m_ptmPeptidesTableModel.getRowCount() <= 0) {
            return null;
        }
        PTMPeptidesTableModel.Row row = this.m_ptmPeptidesTableModel.getPTMPeptideInstanceAt(this.getSelectedRowInTableModel());
        return row != null ? row.ptmPeptideInstance : null;
    }

    private int getSelectedRowInTableModel() {
        int selectedRow = this.m_ptmPeptidesTable.getSelectedRow();
        if (selectedRow == -1) {
            return -1;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmPeptidesTable.getModel();
        selectedRow = this.m_ptmPeptidesTable.convertRowIndexToModel(selectedRow);
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        return selectedRow;
    }

    protected boolean okCalled() {
        this.m_statusModified = this.m_statusPanel.applyModifiedStatus();
        return true;
    }

    protected boolean isClusterModified() {
        return this.m_statusModified || this.m_peptidesDeleted;
    }

    protected boolean isStatusModified() {
        return this.m_statusModified;
    }

    protected boolean isPeptideDeleted() {
        return this.m_peptidesDeleted;
    }

    protected List<PTMPeptideInstance> getRemovedPeptideInstances() {
        return this.m_removedPeptideInstances;
    }

    private class PTMPeptidesTable
    extends LazyTable {
        public PTMPeptidesTable() {
            super(EditClusterDialog.this.m_ptmPeptidesScrollPane.getVerticalScrollBar());
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }

        public void setData(List<PTMPeptideInstance> m_ptmPeptideInstances) {
            ArrayList<PTMCluster> clusters = new ArrayList<PTMCluster>();
            clusters.add(EditClusterDialog.this.m_editedCluster);
            ((PTMPeptidesTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).setData(null, new ArrayList<PTMPeptideInstance>(m_ptmPeptideInstances), clusters, null);
        }
    }
}

