/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic;

import fr.proline.core.orm.uds.RawFile;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectRawFileDialog
extends DefaultDialog {
    private JLabel m_rbFileFromDatabaseLabel = null;
    private JList m_jlist;
    private static SelectRawFileDialog m_singleton = null;

    private SelectRawFileDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Select a Raw File");
        this.setDocumentationSuffix("id.3cqmetx");
        this.setInternalComponent(this.createInternalPanel());
        this.setButtonVisible(2, false);
        this.setButtonVisible(5, false);
    }

    public static SelectRawFileDialog getSelectRawFileDialog(Window parent) {
        if (m_singleton == null) {
            m_singleton = new SelectRawFileDialog(parent);
        }
        return m_singleton;
    }

    public void init(HashMap<String, RawFile> rawFileMap, RunInfoData runInfoData) {
        RawFile linkedRawFile = runInfoData.getLinkedRawFile();
        if (linkedRawFile != null) {
            this.addRawFileInList(rawFileMap, linkedRawFile);
            return;
        }
        RawFile selectedRawFile = runInfoData.getSelectedRawFile();
        if (selectedRawFile != null) {
            this.addRawFileInList(rawFileMap, selectedRawFile);
            return;
        }
        File rawFileOnDisk = runInfoData.getRawFileOnDisk();
        if (rawFileOnDisk != null) {
            this.addRawFileInList(rawFileMap, null);
            return;
        }
        this.addRawFileInList(rawFileMap, null);
    }

    private boolean addRawFileInList(HashMap<String, RawFile> rawFileMap, RawFile rawFileToAdd) {
        DefaultListModel model = (DefaultListModel)this.m_jlist.getModel();
        model.clear();
        boolean rawFileInList = false;
        if (rawFileMap != null && !rawFileMap.isEmpty()) {
            for (RawFile nextRaw : rawFileMap.values()) {
                model.addElement(nextRaw);
                if (rawFileToAdd == null || !nextRaw.equals(rawFileToAdd)) continue;
                rawFileInList = true;
            }
        }
        if (!rawFileInList && rawFileToAdd != null) {
            model.insertElementAt(rawFileToAdd, 0);
            rawFileInList = true;
        }
        if (rawFileInList) {
            this.m_jlist.setSelectedValue(rawFileToAdd, true);
        }
        return rawFileInList;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_rbFileFromDatabaseLabel = new JLabel("Registered Raw File In Database");
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)this.m_rbFileFromDatabaseLabel, c);
        this.m_jlist = new JList();
        DefaultListModel listmodel = new DefaultListModel();
        this.m_jlist.setModel(listmodel);
        this.m_jlist.setCellRenderer(new RawFileListCellRenderer());
        this.m_jlist.setSelectionMode(0);
        JScrollPane fileListScrollPane = new JScrollPane(this.m_jlist){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)fileListScrollPane, c);
        return internalPanel;
    }

    protected boolean okCalled() {
        Object rawFileObject = this.m_jlist.getSelectedValue();
        if (rawFileObject == null) {
            this.setStatus(true, "You must select a Raw File");
            this.highlight(this.m_jlist);
            return false;
        }
        return true;
    }

    public RawFile getSelectedRawFile() {
        return (RawFile)this.m_jlist.getSelectedValue();
    }

    protected boolean cancelCalled() {
        return true;
    }

    private static class RawFileListCellRenderer
    extends DefaultListCellRenderer {
        private RawFileListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            l.setText(((RawFile)value).getRawFileName());
            return l;
        }
    }
}

