/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.model;

import fr.profi.chemistry.model.AbstractMolecularEntityComposition;
import fr.profi.chemistry.model.Atom;
import fr.profi.chemistry.model.AtomTableLike;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0017\ty\u0011\t^8n\u0007>l\u0007o\\:ji&|gN\u0003\u0002\u0004\t\u0005)Qn\u001c3fY*\u0011QAB\u0001\nG\",W.[:uefT!a\u0002\u0005\u0002\u000bA\u0014xNZ5\u000b\u0003%\t!A\u001a:\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0004\u001b9\u0001R\"\u0001\u0002\n\u0005=\u0011!AI!cgR\u0014\u0018m\u0019;N_2,7-\u001e7be\u0016sG/\u001b;z\u0007>l\u0007o\\:ji&|g\u000e\u0005\u0002\u000e#%\u0011!C\u0001\u0002\u0005\u0003R|W\u000e\u0003\u0005\u0015\u0001\t\u0015\r\u0011\"\u0001\u0016\u00031\t'-\u001e8eC:\u001cW-T1q+\u00051\u0002\u0003B\f\u001f!\u0001j\u0011\u0001\u0007\u0006\u00033i\tq!\\;uC\ndWM\u0003\u0002\u001c9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003u\tQa]2bY\u0006L!a\b\r\u0003\u000f!\u000b7\u000f['baB\u0011\u0011EI\u0007\u00029%\u00111\u0005\b\u0002\u0006\r2|\u0017\r\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005-\u0005i\u0011MY;oI\u0006t7-Z'ba\u0002BQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015+!\ti\u0001\u0001C\u0003\u0015M\u0001\u0007a\u0003C\u0003(\u0001\u0011\u0005A\u0006F\u0002*[YBQAL\u0016A\u0002=\nqAZ8s[Vd\u0017\r\u0005\u00021g9\u0011\u0011%M\u0005\u0003eq\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!\u0007\b\u0005\u0006o-\u0002\r\u0001O\u0001\nCR|W\u000eV1cY\u0016\u0004\"!D\u001d\n\u0005i\u0012!!D!u_6$\u0016M\u00197f\u0019&\\W\rC\u0003=\u0001\u0011\u0005S(A\u0003dY>tW\rF\u0001*\u0011\u0015y\u0004\u0001\"\u0001A\u0003=\u0011x.\u001e8e\u0003\n,h\u000eZ1oG\u0016\u001cH#A!\u0011\u0005\u0005\u0012\u0015BA\"\u001d\u0005\u0011)f.\u001b;\t\u000b\u0015\u0003A\u0011\u0002$\u0002#}\u000bGM[;ti:+Xn\u00144Bi>l7\u000f\u0006\u0003B\u000f2s\u0005\"\u0002%E\u0001\u0004I\u0015a\u0002:fM6\u000b7o\u001d\t\u0003C)K!a\u0013\u000f\u0003\r\u0011{WO\u00197f\u0011\u0015iE\t1\u0001J\u0003\u001d\u0019WO]'bgNDQa\u0014#A\u0002Y\t!\u0002Z3mi\u0006\f%-T1q\u0001")
public class AtomComposition
extends AbstractMolecularEntityComposition<Atom> {
    private final HashMap<Atom, Object> abundanceMap;

    @Override
    public HashMap<Atom, Object> abundanceMap() {
        return this.abundanceMap;
    }

    public AtomComposition clone() {
        return new AtomComposition((HashMap<Atom, Object>)((HashMap)this.abundanceMap().clone()));
    }

    public synchronized void roundAbundances() {
        double massBeforeRounding = this.getMonoMass();
        HashMap deltaAbMap = new HashMap();
        this.abundanceMap().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Atom, Object> check$ifrefutable$7) {
                Tuple2<Atom, Object> tuple2 = check$ifrefutable$7;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, deltaAbMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AtomComposition $outer;
            private final HashMap deltaAbMap$1;

            public final void apply(Tuple2<Atom, Object> x$12) {
                Tuple2<Atom, Object> tuple2 = x$12;
                if (tuple2 != null) {
                    Atom atom = (Atom)tuple2._1();
                    float abundance = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    int roundedVal = abundance < 1.0f ? 0 : package$.MODULE$.round(abundance);
                    this.deltaAbMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)atom), (Object)BoxesRunTime.boxToFloat((float)package$.MODULE$.abs(abundance - (float)roundedVal))));
                    this.$outer.abundanceMap().update((Object)atom, (Object)BoxesRunTime.boxToFloat((float)roundedVal));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deltaAbMap$1 = deltaAbMap$1;
            }
        });
        this._adjustNumOfAtoms(massBeforeRounding, this.getMonoMass(), (HashMap<Atom, Object>)deltaAbMap);
    }

    private synchronized void _adjustNumOfAtoms(double refMass, double curMass, HashMap<Atom, Object> deltaAbMap) {
        ObjectRef bestAtom = ObjectRef.create(null);
        FloatRef maxDeltaAb = FloatRef.create((float)0.0f);
        double deltaMass = refMass - curMass;
        double absDeltaMass = package$.MODULE$.abs(deltaMass);
        deltaAbMap.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Atom, Object> check$ifrefutable$8) {
                Tuple2<Atom, Object> tuple2 = check$ifrefutable$8;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, bestAtom, maxDeltaAb, deltaMass, absDeltaMass){
            public static final long serialVersionUID = 0L;
            private final ObjectRef bestAtom$1;
            private final FloatRef maxDeltaAb$1;
            private final double deltaMass$1;
            private final double absDeltaMass$1;

            public final void apply(Tuple2<Atom, Object> x$13) {
                Tuple2<Atom, Object> tuple2 = x$13;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Atom atom = (Atom)tuple2._1();
                    float deltaAb = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    if (deltaAb > this.maxDeltaAb$1.elem) {
                        double atomMass = atom.monoMass();
                        double correctedDeltaMass = 0.0;
                        if (this.deltaMass$1 > 0.0) {
                            correctedDeltaMass = this.deltaMass$1 - atomMass;
                        } else if (this.deltaMass$1 < 0.0) {
                            correctedDeltaMass = this.deltaMass$1 + atomMass;
                        }
                        if (package$.MODULE$.abs(correctedDeltaMass) < this.absDeltaMass$1) {
                            this.bestAtom$1.elem = atom;
                            this.maxDeltaAb$1.elem = package$.MODULE$.abs(deltaAb);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.bestAtom$1 = bestAtom$1;
                this.maxDeltaAb$1 = maxDeltaAb$1;
                this.deltaMass$1 = deltaMass$1;
                this.absDeltaMass$1 = absDeltaMass$1;
            }
        });
        if ((Atom)bestAtom.elem != null) {
            float abundance = BoxesRunTime.unboxToFloat((Object)this.abundanceMap().apply((Object)((Atom)bestAtom.elem)));
            if (deltaMass > 0.0) {
                this.abundanceMap().update((Object)((Atom)bestAtom.elem), (Object)BoxesRunTime.boxToFloat((float)(abundance + 1.0f)));
            } else if (deltaMass < 0.0) {
                this.abundanceMap().update((Object)((Atom)bestAtom.elem), (Object)BoxesRunTime.boxToFloat((float)(abundance - 1.0f)));
            }
            double newCurMass = this.getMonoMass();
            if (package$.MODULE$.abs(refMass - newCurMass) > 0.504) {
                this._adjustNumOfAtoms(refMass, newCurMass, deltaAbMap);
            }
        }
    }

    public AtomComposition(HashMap<Atom, Object> abundanceMap) {
        this.abundanceMap = abundanceMap;
        Predef$.MODULE$.require(abundanceMap != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "abundanceMap is null";
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public AtomComposition(String formula, AtomTableLike atomTable) {
        void var3_3;
        HashMap tmpAbundanceMap = new HashMap();
        String[] formulaElements = formula.split(" ");
        Predef$.MODULE$.refArrayOps((Object[])formulaElements).foreach((Function1)new Serializable(atomTable, tmpAbundanceMap){
            public static final long serialVersionUID = 0L;
            private final AtomTableLike atomTable$1;
            private final HashMap tmpAbundanceMap$2;

            public final HashMap<Atom, Object> apply(String formulaElement) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                if (!formulaElement.contains("(")) {
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formulaElement), (Object)BoxesRunTime.boxToInteger((int)1));
                } else {
                    String[] elemAbParts = formulaElement.split("\\(");
                    String elemSymbol = (String)Predef$.MODULE$.refArrayOps((Object[])elemAbParts).head();
                    int elemQuant = new StringOps(Predef$.MODULE$.augmentString(((String)Predef$.MODULE$.refArrayOps((Object[])elemAbParts).last()).replace(")", ""))).toInt();
                    tuple22 = tuple2 = new Tuple2((Object)elemSymbol, (Object)BoxesRunTime.boxToInteger((int)elemQuant));
                }
                if (tuple2 != null) {
                    Tuple2 tuple23;
                    String atomSymbol = (String)tuple2._1();
                    int abundance = tuple2._2$mcI$sp();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)atomSymbol, (Object)BoxesRunTime.boxToInteger((int)abundance));
                    String atomSymbol2 = (String)tuple24._1();
                    int abundance2 = tuple24._2$mcI$sp();
                    Option<Atom> atomOpt = this.atomTable$1.getAtomOpt(atomSymbol2);
                    Predef$.MODULE$.require(atomOpt.isDefined(), (Function0)new Serializable(this, atomSymbol2){
                        public static final long serialVersionUID = 0L;
                        private final String atomSymbol$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"atom symbol ", " is missing in provided atomTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.atomSymbol$1}));
                        }
                        {
                            this.atomSymbol$1 = atomSymbol$1;
                        }
                    });
                    Atom atom = (Atom)atomOpt.get();
                    return this.tmpAbundanceMap$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)atom), (Object)BoxesRunTime.boxToFloat((float)abundance2)));
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.atomTable$1 = atomTable$1;
                this.tmpAbundanceMap$2 = tmpAbundanceMap$2;
            }
        });
        this((HashMap<Atom, Object>)var3_3);
    }
}

