/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.model;

import fr.profi.chemistry.model.Ionizable;
import fr.profi.chemistry.model.Polarity$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxesRunTime;

public abstract class Ionizable$class {
    public static Ionizable ionize(Ionizable $this, int charge, Enumeration.Value polarity) {
        Predef$.MODULE$.require(charge > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "charge must be a strictly positive integer";
            }
        });
        $this.charge_$eq(charge);
        $this.polarity_$eq(polarity);
        return $this;
    }

    public static Enumeration.Value ionize$default$2(Ionizable $this) {
        return Polarity$.MODULE$.POSITIVE();
    }

    public static double getIonMonoMass(Ionizable $this) {
        return $this.charge() == 0 ? $this.monoMass() : Ionizable$class._neutralMassToIonMass($this, $this.monoMass());
    }

    public static double getIonAverageMass(Ionizable $this) {
        return $this.charge() == 0 ? $this.averageMass() : Ionizable$class._neutralMassToIonMass($this, $this.averageMass());
    }

    private static double _neutralMassToIonMass(Ionizable $this, double neutralMass) {
        Enumeration.Value value;
        block4: {
            double d;
            block3: {
                double deltaMass;
                block2: {
                    deltaMass = (double)$this.charge() * 1.007276466812;
                    value = $this.polarity();
                    Enumeration.Value value2 = Polarity$.MODULE$.POSITIVE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    d = neutralMass + deltaMass;
                    break block3;
                }
                Enumeration.Value value4 = Polarity$.MODULE$.NEGATIVE();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                d = neutralMass - deltaMass;
            }
            return d;
        }
        throw new MatchError((Object)value);
    }

    public static Option getMoz(Ionizable $this) {
        return $this.charge() > 0 ? new Some((Object)BoxesRunTime.boxToDouble((double)($this.getIonMonoMass() / (double)$this.charge()))) : None$.MODULE$;
    }

    public static void $init$(Ionizable $this) {
        $this.charge_$eq(0);
        $this.polarity_$eq(Polarity$.MODULE$.POSITIVE());
    }
}

