/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.ScoresCache;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MultipleAlignmentXMLParser {
    public static List<MultipleAlignmentEnsemble> parseXMLfile(String xml) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<MultipleAlignmentEnsemble> ensembles = new ArrayList<MultipleAlignmentEnsemble>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(xml));
        Document doc = db.parse(inStream);
        doc.getDocumentElement().normalize();
        NodeList listOfEnsembles = doc.getElementsByTagName("MultipleAlignmentEnsemble");
        for (int e = 0; e < listOfEnsembles.getLength(); ++e) {
            Node root = listOfEnsembles.item(e);
            MultipleAlignmentEnsemble ensemble = MultipleAlignmentXMLParser.parseEnsemble(root);
            ensembles.add(ensemble);
        }
        return ensembles;
    }

    public static MultipleAlignmentEnsemble parseEnsemble(Node root) {
        MultipleAlignmentEnsembleImpl ensemble = new MultipleAlignmentEnsembleImpl();
        MultipleAlignmentXMLParser.parseHeader(root, ensemble);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("MultipleAlignment")) {
                MultipleAlignmentXMLParser.parseMultipleAlignment(child, ensemble);
                continue;
            }
            if (child.getNodeName().equals("Structures")) {
                MultipleAlignmentXMLParser.parseStructures(child, ensemble);
                continue;
            }
            if (!child.getNodeName().equals("ScoresCache")) continue;
            MultipleAlignmentXMLParser.parseScoresCache(child, ensemble);
        }
        return ensemble;
    }

    public static MultipleAlignment parseMultipleAlignment(Node root, MultipleAlignmentEnsemble ensemble) {
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl(ensemble);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("BlockSet")) {
                MultipleAlignmentXMLParser.parseBlockSet(child, msa);
                continue;
            }
            if (!child.getNodeName().equals("ScoresCache")) continue;
            MultipleAlignmentXMLParser.parseScoresCache(child, msa);
        }
        return msa;
    }

    public static BlockSet parseBlockSet(Node root, MultipleAlignment msa) {
        BlockSetImpl bs = new BlockSetImpl(msa);
        ArrayList<Matrix4d> transforms = new ArrayList<Matrix4d>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("Block")) {
                MultipleAlignmentXMLParser.parseBlock(child, bs);
                continue;
            }
            if (child.getNodeName().equals("Matrix4d")) {
                Matrix4d t = MultipleAlignmentXMLParser.parseMatrix4d(child);
                transforms.add(t);
                continue;
            }
            if (!child.getNodeName().equals("ScoresCache")) continue;
            MultipleAlignmentXMLParser.parseScoresCache(child, bs);
        }
        if (transforms.size() != 0) {
            bs.setTransformations(transforms);
        }
        return bs;
    }

    public static Block parseBlock(Node root, BlockSet blockSet) {
        BlockImpl b = new BlockImpl(blockSet);
        ArrayList<List<Integer>> alignRes = new ArrayList<List<Integer>>();
        b.setAlignRes(alignRes);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().contains("eqr")) {
                NamedNodeMap atts = child.getAttributes();
                int str = 1;
                Node node = atts.getNamedItem("str" + str);
                while (node != null) {
                    String residue;
                    if (alignRes.size() < str) {
                        alignRes.add(new ArrayList());
                    }
                    if ((residue = node.getTextContent()).equals("null")) {
                        ((List)alignRes.get(str - 1)).add(null);
                    } else {
                        ((List)alignRes.get(str - 1)).add(new Integer(residue));
                    }
                    node = atts.getNamedItem("str" + ++str);
                }
                continue;
            }
            if (!child.getNodeName().equals("ScoresCache")) continue;
            MultipleAlignmentXMLParser.parseScoresCache(child, b);
        }
        return b;
    }

    public static Matrix4d parseMatrix4d(Node node) {
        Matrix4d m = new Matrix4d();
        NamedNodeMap atts = node.getAttributes();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                String key = "mat" + (x + 1) + (y + 1);
                String value = atts.getNamedItem(key).getTextContent();
                m.setElement(x, y, new Double(value).doubleValue());
            }
        }
        return m;
    }

    public static void parseScoresCache(Node root, ScoresCache cache) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            NamedNodeMap atts = child.getAttributes();
            if (atts == null) continue;
            Node score = atts.getNamedItem("value");
            Double value = new Double(score.getTextContent());
            cache.putScore(child.getNodeName(), value);
        }
    }

    public static void parseHeader(Node node, MultipleAlignmentEnsemble ensemble) {
        String time;
        String ioTime;
        String version;
        NamedNodeMap atts = node.getAttributes();
        String algo = atts.getNamedItem("Algorithm").getTextContent();
        if (!algo.equals("null")) {
            ensemble.setAlgorithmName(algo);
        }
        if (!(version = atts.getNamedItem("Version").getTextContent()).equals("null")) {
            ensemble.setVersion(version);
        }
        if (!(ioTime = atts.getNamedItem("IOTime").getTextContent()).equals("null")) {
            ensemble.setIoTime(new Long(ioTime));
        }
        if (!(time = atts.getNamedItem("CalculationTime").getTextContent()).equals("null")) {
            ensemble.setCalculationTime(new Long(time));
        }
    }

    public static void parseStructures(Node root, MultipleAlignmentEnsemble ensemble) {
        ArrayList<StructureIdentifier> names = new ArrayList<StructureIdentifier>();
        ensemble.setStructureIdentifiers(names);
        NamedNodeMap atts = root.getAttributes();
        int str = 1;
        Node node = atts.getNamedItem("name" + str);
        while (node != null) {
            String name = node.getTextContent();
            names.add(new StructureName(name));
            node = atts.getNamedItem("name" + ++str);
        }
    }
}

