/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof.io;

import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.PasefMsMsData;
import fr.profi.brucker.timstof.model.Precursor;
import fr.profi.brucker.timstof.model.TimsMSFrame;
import fr.profi.brucker.timstof.model.TimsPASEFFrame;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDFMetadataReader {
    private static Logger LOG = LoggerFactory.getLogger(TDFMetadataReader.class);
    private Int2ObjectMap<Precursor> m_allPrecursors;
    private File m_ttDirFile;

    protected TDFMetadataReader(File timsTofDataDir) {
        this.m_ttDirFile = timsTofDataDir;
    }

    int getFrameCount() {
        try {
            String tdf_path = Paths.get(this.m_ttDirFile.getAbsolutePath(), "analysis.tdf").toString();
            Connection connection = DriverManager.getConnection("jdbc:sqlite:" + tdf_path);
            Statement statement = connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rsFrames = statement.executeQuery("SELECT COUNT(*) FROM Frames");
            rsFrames.next();
            int numFrames = rsFrames.getInt(1);
            rsFrames.close();
            LOG.debug("number of TIMS frames: " + numFrames);
            return numFrames;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
            return -1;
        }
    }

    Int2ObjectMap<Precursor> getPrecursorInfoById() {
        if (this.m_allPrecursors == null) {
            this.readPrecursorInfo();
        }
        return this.m_allPrecursors;
    }

    private void readPrecursorInfo() {
        if (this.m_allPrecursors == null) {
            Connection connection = this.getConnection();
            this.m_allPrecursors = new Int2ObjectOpenHashMap();
            try {
                if (connection != null) {
                    Statement statement = connection.createStatement();
                    statement.setQueryTimeout(30);
                    ResultSet rsFrames = statement.executeQuery("SELECT Id, LargestPeakMz, AverageMz, MonoisotopicMz, Charge, ScanNumber, Intensity, Parent FROM Precursors");
                    while (rsFrames.next()) {
                        int precId = rsFrames.getInt(1);
                        double largestPeakMz = rsFrames.getDouble(2);
                        double avgMz = rsFrames.getDouble(3);
                        double monoIsotopMz = rsFrames.getDouble(4);
                        int charge = rsFrames.getInt(5);
                        double scanNbr = rsFrames.getDouble(6);
                        double intensity = rsFrames.getDouble(7);
                        int parentFr = rsFrames.getInt(8);
                        Precursor prec = new Precursor(precId, largestPeakMz, avgMz, monoIsotopMz, charge, scanNbr, intensity, parentFr);
                        this.m_allPrecursors.put(precId, (Object)prec);
                    }
                    rsFrames.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                LOG.error(e.getMessage());
            }
        }
    }

    List<AbstractTimsFrame> readFramesInfo(IntList frameIds) {
        ObjectArrayList frames = new ObjectArrayList();
        Connection connection = this.getConnection();
        try {
            if (connection != null) {
                StringBuilder sqlQuery = new StringBuilder("SELECT Id, NumScans, NumPeaks, ScanMode, MsMsType, MaxIntensity, SummedIntensities,  Time FROM Frames WHERE Id in (");
                IntListIterator intListIterator = frameIds.iterator();
                while (intListIterator.hasNext()) {
                    int id = (Integer)intListIterator.next();
                    sqlQuery.append(id).append(",");
                }
                sqlQuery.replace(sqlQuery.length() - 1, sqlQuery.length(), ")");
                Statement statement = connection.createStatement();
                statement.setQueryTimeout(30);
                ResultSet rsFrames = statement.executeQuery(sqlQuery.toString());
                while (rsFrames.next()) {
                    int frId = rsFrames.getInt(1);
                    int nbScans = rsFrames.getInt(2);
                    int nbPeak = rsFrames.getInt(3);
                    int scanMode = rsFrames.getInt(4);
                    int msmsType = rsFrames.getInt(5);
                    int maxInt = rsFrames.getInt(6);
                    int summedInt = rsFrames.getInt(7);
                    double time = rsFrames.getDouble(8);
                    AbstractTimsFrame.MsMsType msmsTypeVal = AbstractTimsFrame.MsMsType.findByCode(msmsType);
                    AbstractTimsFrame frame = null;
                    switch (msmsTypeVal) {
                        case PASEF: {
                            frame = new TimsPASEFFrame(frId, nbScans, nbPeak, scanMode, maxInt, summedInt, time);
                            break;
                        }
                        case MS: {
                            frame = new TimsMSFrame(frId, nbScans, nbPeak, scanMode, maxInt, summedInt, time);
                        }
                    }
                    if (frame == null) continue;
                    frames.add(frame);
                }
                rsFrames.close();
            }
            return frames;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
            return frames;
        }
    }

    void readPasefMsMsInfo(List<TimsPASEFFrame> frames) {
        Int2ObjectOpenHashMap pasefsMsMsInfoByFrId = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap framesById = new Int2ObjectOpenHashMap();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < frames.size(); ++i) {
            int fid = frames.get(i).getId();
            framesById.put(fid, (Object)frames.get(i));
            sb.append(fid);
            if (i >= frames.size() - 1) continue;
            sb.append(',');
        }
        String frIdsAsStr = sb.toString();
        this.readPrecursorInfo();
        Connection connection = this.getConnection();
        try {
            if (connection != null) {
                Statement statement = connection.createStatement();
                statement.setQueryTimeout(30);
                ResultSet rsFrames = statement.executeQuery("SELECT Frame,  ScanNumBegin, ScanNumEnd, IsolationMz, IsolationWidth, CollisionEnergy,  Precursor FROM PasefFrameMsMsInfo WHERE Frame in (" + frIdsAsStr + ")");
                while (rsFrames.next()) {
                    int frId = rsFrames.getInt(1);
                    int startScan = rsFrames.getInt(2);
                    int endScan = rsFrames.getInt(3);
                    double isolationmz = rsFrames.getDouble(4);
                    double isolationWidth = rsFrames.getDouble(5);
                    double collisionEnergy = rsFrames.getDouble(6);
                    int precursorId = rsFrames.getInt(7);
                    PasefMsMsData msmsInfo = new PasefMsMsData(frId, startScan, endScan, isolationmz, isolationWidth, collisionEnergy, precursorId, (float)((AbstractTimsFrame)framesById.get(frId)).getTime());
                    msmsInfo.setPrecursor((Precursor)this.m_allPrecursors.get(precursorId));
                    List frameMsMsInfos = (List)pasefsMsMsInfoByFrId.getOrDefault(frId, new ArrayList());
                    frameMsMsInfos.add(msmsInfo);
                    pasefsMsMsInfoByFrId.put(frId, (Object)frameMsMsInfos);
                }
                rsFrames.close();
                for (TimsPASEFFrame fr : frames) {
                    fr.setPasefMsMsData((List)pasefsMsMsInfoByFrId.getOrDefault(fr.getId(), new ArrayList()));
                }
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
        }
    }

    public Map<String, String> readGlobalMetaData() {
        Connection connection = this.getConnection();
        HashMap<String, String> globalProperties = new HashMap<String, String>();
        try {
            if (connection != null) {
                Statement statement = connection.createStatement();
                statement.setQueryTimeout(30);
                ResultSet rsGlobalMD = statement.executeQuery("SELECT Key, Value FROM GlobalMetadata");
                while (rsGlobalMD.next()) {
                    String key = rsGlobalMD.getString(1);
                    String val = rsGlobalMD.getString(2);
                    globalProperties.put(key, val);
                }
            }
            return globalProperties;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
            return globalProperties;
        }
    }

    private Connection getConnection() {
        try {
            String tdf_path = Paths.get(this.m_ttDirFile.getAbsolutePath(), "analysis.tdf").toString();
            Connection connection = DriverManager.getConnection("jdbc:sqlite:" + tdf_path);
            return connection;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Can't read tilmstof Metadata:  unable to load driver for SQLIte database.");
        }
    }
}

