/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.CSVExporter;
import fr.proline.studio.export.Excel2003Exporter;
import fr.proline.studio.export.ExcelXMLExporter;
import fr.proline.studio.export.ExporterInterface;
import java.util.ArrayList;

public class ExporterFactory {
    public static final int EXPORT_TABLE = 1;
    public static final int EXPORT_IMAGE = 2;
    public static final int EXPORT_FROM_SERVER = 3;
    public static final int EXPORT_XIC = 4;
    public static final int EXPORT_MGF = 5;
    public static final int EXPORT_SPECTRA = 6;
    public static final int EXPORT_MZIDENTML = 7;
    private static ArrayList<ExporterInfo> m_listTable = null;
    private static ArrayList<ExporterInfo> m_listImage = null;
    private static ArrayList<ExporterInfo> m_listServer = null;
    private static ArrayList<ExporterInfo> m_listXic = null;
    private static ArrayList<ExporterInfo> m_listMGF = null;
    private static ArrayList<ExporterInfo> m_listSpectra = null;
    private static ArrayList<ExporterInfo> m_listMzIdent = null;
    public static final ExporterInfo EXPORTER_INFO_PNG = new ExporterInfo(ExporterType.PNG, "PNG (.png)", "png");
    public static final ExporterInfo EXPORTER_INFO_SVG = new ExporterInfo(ExporterType.SVG, "SVG (.svg)", "svg");

    public static ArrayList<ExporterInfo> getList(int exportType) {
        if (exportType == 1) {
            if (m_listTable != null) {
                return m_listTable;
            }
            m_listTable = new ArrayList(3);
            m_listTable.add(new ExporterInfo(ExporterType.EXCEL_XML, "Excel (.xlsx)", "xlsx"));
            m_listTable.add(new ExporterInfo(ExporterType.EXCEL_2003, "Excel 2003 (.xls)", "xls"));
            m_listTable.add(new ExporterInfo(ExporterType.CSV, "CSV (.csv)", "csv"));
            return m_listTable;
        }
        if (exportType == 6) {
            if (m_listSpectra != null) {
                return m_listSpectra;
            }
            m_listSpectra = new ArrayList(1);
            m_listSpectra.add(new ExporterInfo(ExporterType.TSV, "TSV (.tsv)", "tsv"));
            return m_listSpectra;
        }
        if (exportType == 2) {
            if (m_listImage != null) {
                return m_listImage;
            }
            m_listImage = new ArrayList(2);
            m_listImage.add(EXPORTER_INFO_PNG);
            m_listImage.add(EXPORTER_INFO_SVG);
            return m_listImage;
        }
        if (exportType == 4) {
            if (m_listXic != null) {
                return m_listXic;
            }
            m_listXic = new ArrayList(1);
            m_listXic.add(new ExporterInfo(ExporterType.EXCEL_XML, "Excel (.xlsx)", "xlsx"));
            m_listXic.add(new ExporterInfo(ExporterType.EXCEL_2003, "Excel 2003 (.xls)", "xls"));
            return m_listXic;
        }
        if (exportType == 3) {
            if (m_listServer != null) {
                return m_listServer;
            }
            m_listServer = new ArrayList(1);
            m_listServer.add(new ExporterInfo(ExporterType.EXCEL_XML, "Excel (.xlsx)", "xlsx"));
            return m_listServer;
        }
        if (exportType == 5) {
            if (m_listMGF != null) {
                return m_listMGF;
            }
            m_listMGF = new ArrayList(2);
            m_listMGF.add(new ExporterInfo(ExporterType.MGF, "MGF (.mgf)", "mgf"));
            m_listMGF.add(new ExporterInfo(ExporterType.TSV, "TSV (.tsv)", "tsv"));
            return m_listMGF;
        }
        if (exportType == 7) {
            if (m_listMzIdent != null) {
                return m_listMzIdent;
            }
            m_listMzIdent = new ArrayList(1);
            m_listMzIdent.add(new ExporterInfo(ExporterType.MZID, "MzIdentML (.mzid)", "mzid"));
            return m_listMzIdent;
        }
        return new ArrayList<ExporterInfo>();
    }

    public static class ExporterInfo {
        private final ExporterType m_type;
        private final String m_name;
        private final String m_fileExtension;

        public ExporterInfo(ExporterType type, String name, String fileExtension) {
            this.m_type = type;
            this.m_name = name;
            this.m_fileExtension = fileExtension;
        }

        public ExporterType geType() {
            return this.m_type;
        }

        public String getName() {
            return this.m_name;
        }

        public String getFileExtension() {
            return this.m_fileExtension;
        }

        public ExporterInterface getExporter() {
            switch (this.m_type) {
                case EXCEL_XML: {
                    return new ExcelXMLExporter();
                }
                case EXCEL_2003: {
                    return new Excel2003Exporter();
                }
                case CSV: {
                    return new CSVExporter();
                }
            }
            return null;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static enum ExporterType {
        EXCEL_XML,
        EXCEL_2003,
        CSV,
        PNG,
        SVG,
        MGF,
        TSV,
        MZID;

    }
}

