/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterList;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public abstract class AbstractLinkedParameters {
    private ParameterList m_parameterList = null;

    public AbstractLinkedParameters(ParameterList parameterList) {
        this.m_parameterList = parameterList;
    }

    public ParameterList getParameterList() {
        return this.m_parameterList;
    }

    public abstract void valueChanged(String var1, Object var2);

    public void showParameter(AbstractParameter parameter, boolean show) {
        JComponent comp = parameter.getComponent(null);
        comp.setVisible(show);
        JLabel l = this.getParameterList().getAssociatedLabel(comp);
        if (l != null) {
            l.setVisible(show);
        }
        this.m_parameterList.displayModified();
    }

    public void showParameter(AbstractParameter parameter, boolean show, Object value) {
        JComponent comp = parameter.getComponent(value);
        comp.setVisible(show);
        JLabel l = this.getParameterList().getAssociatedLabel(comp);
        if (l != null) {
            l.setVisible(show);
        }
    }

    public void enableList(boolean v) {
        this.m_parameterList.enableList(v);
    }

    protected void updateParameterListPanel() {
        Container c;
        ParameterList.ParametersPanel p = this.getParameterList().getPanel();
        JDialog dialog = this.getParent(p);
        if (dialog != null) {
            if (dialog instanceof DefaultDialog) {
                ((DefaultDialog)dialog).repack();
            } else {
                dialog.pack();
            }
        } else if (p != null && (c = p.getParent()) != null) {
            c.revalidate();
        }
    }

    private JDialog getParent(JComponent c) {
        Container container = c.getParent();
        while (container != null) {
            if (container instanceof JDialog) {
                return (JDialog)container;
            }
            container = container.getParent();
        }
        return null;
    }
}

