/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DoubleParameter
extends AbstractParameter {
    private Double m_minValue;
    private Double m_maxValue;
    private Double m_defaultValue;
    private Double m_startValue;
    private boolean m_edited = false;
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;

    public DoubleParameter(String key, String name, Class graphicalType, Double defaultValue, Double minValue, Double maxValue) {
        super(key, name, Double.class, graphicalType);
        this.m_defaultValue = defaultValue;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
    }

    public DoubleParameter(String key, String name, JComponent component, Double defaultValue, Double minValue, Double maxValue) {
        super(key, name, Double.class, component.getClass());
        this.m_defaultValue = defaultValue;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        this.m_parameterComponent = component;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = null;
        if (value != null) {
            try {
                double valueParsed = Double.parseDouble(value.toString());
                this.m_startValue = new Double(valueParsed);
            }
            catch (NumberFormatException valueParsed) {
                // empty catch block
            }
        }
        if (this.m_startValue == null) {
            this.m_startValue = this.m_defaultValue;
        }
        if (this.m_parameterComponent != null && this.m_graphicalType.equals(JTextField.class)) {
            if (value != null) {
                ((JTextField)this.m_parameterComponent).setText(value.toString());
            } else if (this.m_defaultValue != null) {
                ((JTextField)this.m_parameterComponent).setText(this.m_defaultValue.toString());
            }
            return this.m_parameterComponent;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = new JTextField(3);
            if (value != null) {
                textField.setText(value.toString());
            } else if (this.m_defaultValue != null) {
                textField.setText(this.m_defaultValue.toString());
            }
            this.m_parameterComponent = textField;
            return textField;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultValue == null) {
            return;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            textField.setText(this.m_defaultValue.toString());
        }
    }

    @Override
    public ParameterError checkParameter() {
        if (!this.m_used && !this.m_compulsory) {
            return null;
        }
        Double value = null;
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            try {
                value = Double.parseDouble(textField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                return new ParameterError(this.m_name + " is  not a Number", this.m_parameterComponent);
            }
        }
        if (this.m_minValue != null && value < this.m_minValue) {
            return new ParameterError(this.m_name + " must be greater than " + this.m_minValue.toString(), this.m_parameterComponent);
        }
        if (this.m_maxValue != null && value > this.m_maxValue) {
            return new ParameterError(this.m_name + " must be lesser than " + this.m_maxValue.toString(), this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_graphicalType.equals(JTextField.class) && this.m_parameterComponent != null) {
            ((JTextField)this.m_parameterComponent).setText(v);
        }
        if (v != null && this.m_startValue != null) {
            this.m_edited = Double.parseDouble(v) != this.m_startValue;
        }
    }

    @Override
    public String getStringValue() {
        String v = this.getObjectValue().toString();
        if (!v.contains(".") && !v.contains("e")) {
            v = v + ".0";
        }
        return v;
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(JTextField.class)) {
            return ((JTextField)this.m_parameterComponent).getText().trim();
        }
        return "";
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_graphicalType.equals(JTextField.class)) {
            ((JTextField)this.m_parameterComponent).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                public void textChanged() {
                    String valueString = (String)DoubleParameter.this.getObjectValue();
                    try {
                        Double d = Double.valueOf(valueString);
                        linkedParameters.valueChanged(valueString, d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

