/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.AbstractParameterToString;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterValueRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ObjectParameter<E>
extends AbstractParameter {
    private E[] m_objects;
    private Object[] m_associatedObjects = null;
    private final int m_defaultIndex;
    private AbstractParameterToString<E> m_paramToString = null;
    private boolean m_edited = false;
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;

    public ObjectParameter(String key, String name, E[] objects, int defaultIndex, AbstractParameterToString<E> paramToString) {
        super(key, name, Integer.class, JComboBox.class);
        this.m_objects = objects;
        if (defaultIndex < 0 || defaultIndex >= objects.length) {
            defaultIndex = 0;
        }
        this.m_defaultIndex = defaultIndex;
        this.m_paramToString = paramToString;
    }

    public ObjectParameter(String key, String name, JComboBox comboBox, E[] objects, Object[] associatedObjects, int defaultIndex, AbstractParameterToString<E> paramToString) {
        super(key, name, Integer.class, JComboBox.class);
        this.m_objects = objects;
        if (defaultIndex < 0 || defaultIndex >= objects.length) {
            defaultIndex = 0;
        }
        this.m_defaultIndex = defaultIndex;
        this.m_paramToString = paramToString;
        this.m_parameterComponent = comboBox;
        this.m_associatedObjects = associatedObjects;
        if (paramToString != null) {
            comboBox.setRenderer(new ParameterValueRenderer<E>(paramToString));
        }
    }

    public void updateObjects(E[] objects) {
        this.m_objects = objects;
    }

    public void updateAssociatedObjects(Object[] associatedObjects) {
        this.m_associatedObjects = associatedObjects;
    }

    @Override
    public JComponent getComponent(Object value) {
        if (this.m_parameterComponent != null && this.m_graphicalType.equals(JComboBox.class)) {
            JComboBox combobox = (JComboBox)this.m_parameterComponent;
            if (value == null || !this.selectItem(combobox, value)) {
                combobox.setSelectedIndex(this.m_defaultIndex);
            }
            return this.m_parameterComponent;
        }
        if (this.m_graphicalType.equals(JComboBox.class)) {
            JComboBox<Object> combobox = new JComboBox<Object>(this.m_objects);
            combobox.setRenderer(new ParameterValueRenderer<E>(this.m_paramToString));
            if (value == null || !this.selectItem(combobox, value)) {
                combobox.setSelectedIndex(this.m_defaultIndex);
            }
            this.m_parameterComponent = combobox;
            return combobox;
        }
        return null;
    }

    private boolean selectItem(JComboBox comboBox, Object value) {
        try {
            String valueString = value == null ? "" : value.toString();
            int nb = comboBox.getItemCount();
            for (int i = 0; i < nb; ++i) {
                String itemString = this.getStringValue(comboBox, i);
                if (itemString.compareTo(valueString) != 0) continue;
                comboBox.setSelectedIndex(i);
                return true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "SELECT ITEM EXCEPTION " + e);
        }
        return false;
    }

    @Override
    public void initDefault() {
        ((JComboBox)this.m_parameterComponent).setSelectedIndex(this.m_defaultIndex);
    }

    @Override
    public ParameterError checkParameter() {
        if (!this.m_used && !this.m_compulsory) {
            return null;
        }
        if (this.m_graphicalType.equals(JComboBox.class) && ((JComboBox)this.m_parameterComponent).getSelectedItem() == null) {
            return new ParameterError("Invalid Selection", this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_parameterComponent == null) {
            return;
        }
        if (this.m_graphicalType.equals(JComboBox.class)) {
            this.selectItem((JComboBox)this.m_parameterComponent, v);
            this.m_edited = ((JComboBox)this.m_parameterComponent).getSelectedIndex() != this.m_defaultIndex;
        }
    }

    @Override
    public String getStringValue() {
        if (this.m_associatedObjects == null) {
            E item = this.getObjectValue();
            return this.getStringValue(item);
        }
        Object item = this.getAssociatedObjectValue();
        if (item == null) {
            return "";
        }
        return item.toString();
    }

    private String getStringValue(E item) {
        if (item == null) {
            return "";
        }
        if (this.m_paramToString != null) {
            return this.m_paramToString.toString(item);
        }
        return item.toString();
    }

    private String getStringValue(JComboBox comboBox, int index) {
        if (this.m_associatedObjects == null) {
            return this.getStringValue(comboBox.getItemAt(index));
        }
        Object associatedObject = this.m_associatedObjects[index];
        if (associatedObject == null) {
            return "";
        }
        return associatedObject.toString();
    }

    public E getObjectValue() {
        if (this.m_graphicalType.equals(JComboBox.class)) {
            if (this.m_parameterComponent == null) {
                return null;
            }
            return (E)((JComboBox)this.m_parameterComponent).getSelectedItem();
        }
        return null;
    }

    public Object getAssociatedObjectValue() {
        if (this.m_associatedObjects == null) {
            return this.getObjectValue();
        }
        if (this.m_graphicalType.equals(JComboBox.class)) {
            if (this.m_parameterComponent == null) {
                if (this.m_defaultIndex != -1) {
                    return this.m_associatedObjects[this.m_defaultIndex];
                }
                return null;
            }
            int index = ((JComboBox)this.m_parameterComponent).getSelectedIndex();
            if (index == -1) {
                return null;
            }
            return this.m_associatedObjects[index];
        }
        return null;
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_parameterComponent instanceof JComboBox) {
            ((JComboBox)this.m_parameterComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    linkedParameters.valueChanged(ObjectParameter.this.getStringValue(), ObjectParameter.this.getAssociatedObjectValue());
                }
            });
            this.initDefault();
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

