
/* SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */

ALTER TABLE public.run DROP CONSTRAINT raw_file_run_fk;

ALTER TABLE public.run_identification DROP CONSTRAINT raw_file_run_identification_fk;

ALTER TABLE public.raw_file_project_map DROP CONSTRAINT raw_file_raw_file_project_map_fk;

ALTER TABLE public.run RENAME COLUMN raw_file_name TO raw_file_identifier;

-- MANUAL CHANGE: set default write_permission to true
ALTER TABLE public.project_user_account_map ADD COLUMN write_permission BOOLEAN DEFAULT true NOT NULL;

ALTER TABLE public.run_identification RENAME COLUMN raw_file_name TO raw_file_identifier;

ALTER TABLE public.spec_title_parsing_rule RENAME COLUMN raw_file_name TO raw_file_identifier;
COMMENT ON TABLE public.peaklist_software IS 'Describes software that can be used to generate MS/MS peaklists.';

ALTER TABLE public.raw_file_project_map RENAME COLUMN raw_file_name TO raw_file_identifier;

-- MANUAL CHANGE: SQL query disabled here (applied after data migration)
--ALTER TABLE public.sample_analysis DROP COLUMN number;

ALTER TABLE public.raw_file ADD COLUMN mzdb_file_directory VARCHAR(500);

ALTER TABLE public.raw_file RENAME COLUMN name TO identifier;

-- MANUAL CHANGE: "NOT NULL" constraint removed (re-added after data migration)
ALTER TABLE public.raw_file ADD COLUMN raw_file_name VARCHAR(250);

ALTER TABLE public.raw_file DROP COLUMN extension;

ALTER TABLE public.raw_file RENAME COLUMN directory TO raw_file_directory;

ALTER TABLE public.raw_file ADD COLUMN sample_name VARCHAR(250);

ALTER TABLE public.raw_file ADD COLUMN mzdb_file_name VARCHAR(250);
COMMENT ON TABLE public.instrument IS 'This table lists the user mass spectrometers.';

ALTER TABLE public.project ADD COLUMN lock_expiration_timestamp TIMESTAMP;

ALTER TABLE public.project ADD COLUMN lock_user_id BIGINT;

-- MANUAL CHANGE: "NOT NULL" constraint removed (re-added after data migration)
ALTER TABLE public.biological_sample_sample_analysis_map ADD COLUMN sample_analysis_number INTEGER;

CREATE INDEX object_tree_schema_name_idx
 ON public.object_tree
 ( schema_name );

CREATE UNIQUE INDEX peaklist_software_idx
 ON public.peaklist_software
 ( name, version );

CREATE UNIQUE INDEX biological_sample_sample_analysis_map_idx
 ON public.biological_sample_sample_analysis_map
 ( biological_sample_id, sample_analysis_number );

ALTER TABLE public.project ADD CONSTRAINT user_account_project_lock_user_fk
FOREIGN KEY (lock_user_id)
REFERENCES public.user_account (id)
ON DELETE NO ACTION
ON UPDATE NO ACTION
NOT DEFERRABLE;

/*  MANUAL CHANGE: constraint after data migration 
ALTER TABLE public.run ADD CONSTRAINT raw_file_run_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE CASCADE
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.run_identification ADD CONSTRAINT raw_file_run_identification_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.raw_file_project_map ADD CONSTRAINT raw_file_raw_file_project_map_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE; */

/* END OF SCRIPT GENERATED BY POWER ARCHITECT AND MODIFIED MANUALLY */

/* ADDITIONAL SQL QUERIES USED FOR DATA UPDATE */


-- MOVE sample number to mapping table
UPDATE biological_sample_sample_analysis_map SET sample_analysis_number = sample_analysis.number FROM sample_analysis WHERE biological_sample_sample_analysis_map.sample_analysis_id = sample_analysis.id;
ALTER TABLE biological_sample_sample_analysis_map ALTER COLUMN sample_analysis_number SET NOT NULL;
ALTER TABLE public.sample_analysis DROP COLUMN number;


-- update identifier by removing path and extension element
UPDATE raw_file SET identifier = shortName.newVal
FROM (
select substring(raw_file.identifier from startIndex.start for (endIndex.end-startIndex.start)) as  newVal, raw_file.identifier as id
from 
( select (length(raw_file.identifier) - lastIndex.ind) as start, raw_file.identifier 
  from
    (    
    select identifier, case WHEN position('\' in reverse(raw_file.identifier)) = 0 THEN length(raw_file.identifier)-1
	                    ELSE (position('\' in reverse(raw_file.identifier)))-2
	                END as ind
	                FROM raw_file
    ) lastIndex, 
    raw_file
  where lastIndex.identifier = raw_file.identifier
) startIndex,

( select (length(raw_file.identifier) - lastEndIndex.ind ) as end, raw_file.identifier 
  from
    (select identifier,  case WHEN position('.' in reverse(raw_file.identifier)) = 0 THEN -1
	         ELSE position('.' in reverse(raw_file.identifier))-1
	    END as ind
	    from raw_file
     ) lastEndIndex, 
    raw_file
  where lastEndIndex.identifier = raw_file.identifier

) endIndex,
raw_file
where startIndex.identifier = raw_file.identifier
and endIndex.identifier = raw_file.identifier
) shortName
WHERE shortName.id = raw_file.identifier;

-- UPDATE run_identification.raw_file_identifier field  using same rules as raw_file.identifier
UPDATE run_identification SET raw_file_identifier = shortName.newVal
FROM (
  select substring(run_identification.raw_file_identifier from startIndex.start for (endIndex.end-startIndex.start)) as  newVal, run_identification.id as id
  from 
	( select (length(run_identification.raw_file_identifier) - lastIndex.ind) as start, run_identification.id as ident 
	  from
		(    
		select id, case WHEN position('\' in reverse(run_identification.raw_file_identifier)) = 0 THEN length(run_identification.raw_file_identifier)-1
	                       ELSE (position('\' in reverse(run_identification.raw_file_identifier)))-2
	                   END as ind
	        FROM run_identification
		) lastIndex, 
		run_identification
	  where lastIndex.id = run_identification.id
	) startIndex,

	( select (length(run_identification.raw_file_identifier) - lastEndIndex.ind ) as end, run_identification.id as ident  
	from
		(select id,  case WHEN position('.' in reverse(run_identification.raw_file_identifier)) = 0 THEN -1
				  ELSE position('.' in reverse(run_identification.raw_file_identifier))-1
			     END as ind
		from run_identification
		) lastEndIndex, 
		run_identification
	where lastEndIndex.id = run_identification.id
	) endIndex,
	run_identification
  where startIndex.ident = run_identification.id
  and endIndex.ident = run_identification.id
) shortName
WHERE shortName.id = run_identification.id;

-- UPDATE run.raw_file_identifier field  using same rules as raw_file.identifier
UPDATE run SET raw_file_identifier = shortName.newVal
FROM (
  select substring(run.raw_file_identifier from startIndex.start for (endIndex.end-startIndex.start)) as  newVal, run.id as id
  from 
	( select (length(run.raw_file_identifier) - lastIndex.ind) as start, run.id as ident 
	  from
		(    
		select id, case WHEN position('\' in reverse(run.raw_file_identifier)) = 0 THEN length(run.raw_file_identifier)-1
	                       ELSE (position('\' in reverse(run.raw_file_identifier)))-2
	                   END as ind
	        FROM run
		) lastIndex, 
		run
	  where lastIndex.id = run.id
	) startIndex,

	( select (length(run.raw_file_identifier) - lastEndIndex.ind ) as end, run.id as ident  
	from
		(select id,  case WHEN position('.' in reverse(run.raw_file_identifier)) = 0 THEN -1
				  ELSE position('.' in reverse(run.raw_file_identifier))-1
			     END as ind
		from run
		) lastEndIndex, 
		run
	where lastEndIndex.id = run.id
	) endIndex,
	run
  where startIndex.ident = run.id
  and endIndex.ident = run.id
) shortName
WHERE shortName.id = run.id;

-- UPDATE raw_file_project_map.raw_file_identifier field  using same rules as raw_file.identifier
UPDATE raw_file_project_map SET raw_file_identifier = shortName.newVal
FROM (
select substring(raw_file_project_map.raw_file_identifier from startIndex.start for (endIndex.end-startIndex.start)) as  newVal, raw_file_project_map.raw_file_identifier as prevVal
from 
  ( select (length(raw_file_project_map.raw_file_identifier) - lastIndex.ind) as start, raw_file_project_map.raw_file_identifier as prevVal
    from
    (    
      select raw_file_identifier as prevVal, case WHEN position('\' in reverse(raw_file_project_map.raw_file_identifier)) = 0 THEN length(raw_file_project_map.raw_file_identifier)-1
	                    ELSE (position('\' in reverse(raw_file_project_map.raw_file_identifier)))-2
	                END as ind
	                FROM raw_file_project_map
    ) lastIndex, 
    raw_file_project_map
   where lastIndex.prevVal = raw_file_project_map.raw_file_identifier
) startIndex,

( select (length(raw_file_project_map.raw_file_identifier) - lastEndIndex.ind ) as end, raw_file_project_map.raw_file_identifier as prevVal
  from
    (select raw_file_identifier as prevVal,  case WHEN position('.' in reverse(raw_file_project_map.raw_file_identifier)) = 0 THEN -1
	         ELSE position('.' in reverse(raw_file_project_map.raw_file_identifier))-1
	    END as ind
	    from raw_file_project_map
     ) lastEndIndex, 
    raw_file_project_map
  where lastEndIndex.prevVal = raw_file_project_map.raw_file_identifier

) endIndex,
raw_file_project_map
where startIndex.prevVal = raw_file_project_map.raw_file_identifier
and endIndex.prevVal = raw_file_project_map.raw_file_identifier
) shortName
WHERE shortName.prevVal = raw_file_project_map.raw_file_identifier;

-- ADD 'raw' extension to identifier to create raw_file_name  : remove wrong extension (mzdb...) 
UPDATE raw_file SET raw_file_name = identifier || '.raw'; 
ALTER TABLE raw_file ALTER COLUMN raw_file_name SET NOT NULL;

ALTER TABLE public.run ADD CONSTRAINT raw_file_run_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE CASCADE
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.run_identification ADD CONSTRAINT raw_file_run_identification_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE;

ALTER TABLE public.raw_file_project_map ADD CONSTRAINT raw_file_raw_file_project_map_fk
FOREIGN KEY (raw_file_identifier)
REFERENCES public.raw_file (identifier)
ON DELETE RESTRICT
ON UPDATE NO ACTION
NOT DEFERRABLE;

/* END OF ADDITIONAL SQL QUERIES USED FOR DATA UPDATE */

/* LIST OF OPERATIONS TO BE PERFORMED IN THE NEXT JAVA MIGRATION */
-- Get value of mzDb file name and directory from serialized property
/* END LIST OF OPERATIONS TO BE PERFORMED IN THE NEXT JAVA MIGRATION */