/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.RectangleImpl;

public final class Point
implements Rectangle {
    private final float x;
    private final float y;

    private Point(float x, float y) {
        this.x = x;
        this.y = y;
    }

    static Point create(double x, double y) {
        return new Point((float)x, (float)y);
    }

    static Point create(float x, float y) {
        return new Point(x, y);
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    @Override
    public double distance(Rectangle r) {
        return RectangleImpl.distance(this.x, this.y, this.x, this.y, r.x1(), r.y1(), r.x2(), r.y2());
    }

    public double distance(Point p) {
        return Math.sqrt(this.distanceSquared(p));
    }

    public double distanceSquared(Point p) {
        float dx = this.x - p.x;
        float dy = this.y - p.y;
        return dx * dx + dy * dy;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return r.x1() <= this.x && this.x <= r.x2() && r.y1() <= this.y && this.y <= r.y2();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        return "Point [x=" + this.x() + ", y=" + this.y() + "]";
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    @Override
    public float x1() {
        return this.x;
    }

    @Override
    public float y1() {
        return this.y;
    }

    @Override
    public float x2() {
        return this.x;
    }

    @Override
    public float y2() {
        return this.y;
    }

    @Override
    public float area() {
        return 0.0f;
    }

    @Override
    public Rectangle add(Rectangle r) {
        return RectangleImpl.create(Math.min(this.x, r.x1()), Math.min(this.y, r.y1()), Math.max(this.x, r.x2()), Math.max(this.y, r.y2()));
    }

    @Override
    public boolean contains(double x, double y) {
        return (double)this.x == x && (double)this.y == y;
    }

    @Override
    public float intersectionArea(Rectangle r) {
        return 0.0f;
    }

    @Override
    public float perimeter() {
        return 0.0f;
    }
}

