/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import fr.profi.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final String RELEASE_DATE_FORMAT = "yyyyMMdd";

    private DateUtils() {
    }

    public static Date parseReleaseDate(String rawDate) {
        Date result = null;
        if (!StringUtils.isEmpty(rawDate)) {
            SimpleDateFormat df = new SimpleDateFormat(RELEASE_DATE_FORMAT);
            try {
                Date d = df.parse(rawDate);
                result = DateUtils.clearTime(d);
            }
            catch (ParseException pEx) {
                LOG.warn("Unable to parse [" + rawDate + "] as a date value", (Throwable)pEx);
            }
        }
        return result;
    }

    public static String formatReleaseDate(Date date) {
        String result = null;
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(RELEASE_DATE_FORMAT);
            result = df.format(date);
        }
        return result;
    }

    public static Date clearTime(Date src) {
        if (src == null) {
            throw new IllegalArgumentException("Src is null");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(src);
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        return cal.getTime();
    }
}

