/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.InstrumentConfiguration;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="findMsiInstrumConfForNameAndMs1AndMsn", query="select ic from fr.proline.core.orm.msi.InstrumentConfig ic where (upper(ic.name) = :name) and (upper(ic.ms1Analyzer) = :ms1Analyzer) and (upper(ic.msnAnalyzer) = :msnAnalyzer)"), @NamedQuery(name="findMsiInstrumConfForNameAndMs1", query="select ic from fr.proline.core.orm.msi.InstrumentConfig ic where (upper(ic.name) = :name) and (upper(ic.ms1Analyzer) = :ms1Analyzer) and (ic.msnAnalyzer is null)")})
@Table(name="instrument_config")
public class InstrumentConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private long id;
    @Column(name="ms1_analyzer")
    private String ms1Analyzer;
    @Column(name="msn_analyzer")
    private String msnAnalyzer;
    private String name;
    @Column(name="serialized_properties")
    private String serializedProperties;

    public InstrumentConfig() {
    }

    public InstrumentConfig(InstrumentConfiguration udsInstrumentConfig) {
        if (udsInstrumentConfig == null) {
            throw new IllegalArgumentException("UdsInstrumentConfig is null");
        }
        this.setId(udsInstrumentConfig.getId());
        this.setMs1Analyzer(udsInstrumentConfig.getMs1Analyzer());
        String udsMsnAnalyz = udsInstrumentConfig.getMsnAnalyzer();
        if (StringUtils.isEmpty((String)udsMsnAnalyz)) {
            this.setMsnAnalyzer(null);
        } else {
            this.setMsnAnalyzer(udsMsnAnalyz);
        }
        this.setName(udsInstrumentConfig.getName());
        String udsInstrumentConfigProps = udsInstrumentConfig.getSerializedProperties();
        if (StringUtils.isEmpty((String)udsInstrumentConfigProps)) {
            this.setSerializedProperties(null);
        } else {
            this.setSerializedProperties(udsInstrumentConfigProps);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getMs1Analyzer() {
        return this.ms1Analyzer;
    }

    public void setMs1Analyzer(String ms1Analyzer) {
        this.ms1Analyzer = ms1Analyzer;
    }

    public String getMsnAnalyzer() {
        return this.msnAnalyzer;
    }

    public void setMsnAnalyzer(String msnAnalyzer) {
        this.msnAnalyzer = msnAnalyzer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }
}

