/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.proline.core.orm.uds.BiologicalSplSplAnalysisMap;
import fr.proline.core.orm.uds.BiologicalSplSplAnalysisMapPK;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.SampleAnalysis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="biological_sample")
public class BiologicalSample
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String name;
    private int number;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @ManyToOne
    @JoinColumn(name="quantitation_id")
    private Dataset dataset;
    @OneToMany(mappedBy="biologicalSample")
    @OrderBy(value="number")
    private List<QuantitationChannel> quantitationChannels;
    @OneToMany(mappedBy="biologicalSample")
    @OrderBy(value="sampleAnalysisNumber")
    private List<BiologicalSplSplAnalysisMap> biologicalSplSplAnalysisMap;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int pNumber) {
        this.number = pNumber;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public List<QuantitationChannel> getQuantitationChannels() {
        return this.quantitationChannels;
    }

    public void setQuantitationChannels(List<QuantitationChannel> quantitationChannels) {
        this.quantitationChannels = quantitationChannels;
    }

    public BiologicalSplSplAnalysisMap addSampleAnalysis(SampleAnalysis sampleAnalysis) {
        BiologicalSplSplAnalysisMap item = new BiologicalSplSplAnalysisMap();
        BiologicalSplSplAnalysisMapPK key = new BiologicalSplSplAnalysisMapPK();
        key.setBiologicalSampleId(this.getId());
        key.setSampleAnalysisId(sampleAnalysis.getId());
        item.setId(key);
        item.setBiologicalSample(this);
        item.setSampleAnalysis(sampleAnalysis);
        item.setSampleAnalysisNumber(this.getBiologicalSplSplAnalysisMap().size() + 1);
        sampleAnalysis.addBiologicalSample(item);
        return this.getBiologicalSplSplAnalysisMap().add(item) ? item : null;
    }

    public List<SampleAnalysis> getSampleAnalyses() {
        return this.getBiologicalSplSplAnalysisMap().stream().map(i -> i.getSampleAnalysis()).collect(Collectors.toList());
    }

    private List<BiologicalSplSplAnalysisMap> getBiologicalSplSplAnalysisMap() {
        if (this.biologicalSplSplAnalysisMap == null) {
            this.biologicalSplSplAnalysisMap = new ArrayList<BiologicalSplSplAnalysisMap>();
        }
        return this.biologicalSplSplAnalysisMap;
    }
}

