/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Ontology;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public final class Util {
    public static void writeToErrorLog(String logEntry) {
        System.out.println(new Date(System.currentTimeMillis()).toString() + ": " + logEntry);
    }

    public static List<Ontology> refineOntologyNames(List<Ontology> ontologies) {
        ArrayList<Ontology> resultOntologies = new ArrayList<Ontology>();
        if (ontologies != null && ontologies.size() > 0) {
            for (Ontology key : ontologies) {
                if (key.getName().length() > 80) {
                    key.setName(key.getName().substring(0, 50) + "..");
                    resultOntologies.add(key);
                    continue;
                }
                resultOntologies.add(key);
            }
        }
        return resultOntologies;
    }

    public static List<Term> refineOntologyNullIds(List<Term> roots) {
        ArrayList<Term> result = new ArrayList<Term>();
        if (roots != null && roots.size() > 0) {
            for (Term key : roots) {
                if (key.getGlobalId() == null || key.getGlobalId().getIdentifier() == null) continue;
                result.add(key);
            }
        }
        return result;
    }

    public static Ontology findOntology(List<Ontology> ontologies, String shortName) {
        if (ontologies != null && shortName != null) {
            for (Ontology ontology : ontologies) {
                if (!ontology.getId().equalsIgnoreCase(shortName)) continue;
                return ontology;
            }
        }
        return null;
    }

    public static String getOlsAccessionLink(ITerm term) {
        String notSelectedRowHtmlTagFontColor = "#0101DF";
        return "<html><a href=\"http://www.ebi.ac.uk/ols/beta/ontologies/" + term.getOntologyName() + "/terms?iri=" + term.getIri() + "\"\"><font color=\"" + notSelectedRowHtmlTagFontColor + "\">" + term.getGlobalId().getIdentifier() + "</font></a></html>";
    }

    public static String getOlsTermLink(ITerm term) {
        return "http://www.ebi.ac.uk/ols/beta/ontologies/" + term.getOntologyName() + "/terms?iri=" + term.getIri().getIdentifier();
    }
}

