/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import org.biojava.nbio.alignment.template.AbstractScorer;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.alignment.template.PairwiseSequenceScorer;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class FractionalIdentityScorer<S extends Sequence<C>, C extends Compound>
extends AbstractScorer
implements PairwiseSequenceScorer<S, C> {
    private S query;
    private S target;
    private int max;
    private int score;
    private PairwiseSequenceAligner<S, C> aligner;

    public FractionalIdentityScorer(PairwiseSequenceAligner<S, C> aligner) {
        this.query = aligner.getQuery();
        this.target = aligner.getTarget();
        this.aligner = aligner;
    }

    public FractionalIdentityScorer(SequencePair<S, C> pair) {
        this.query = pair.getQuery().getOriginalSequence();
        this.target = pair.getTarget().getOriginalSequence();
        this.max = pair.getLength();
        this.score = pair.getNumIdenticals();
    }

    @Override
    public S getQuery() {
        return this.query;
    }

    @Override
    public S getTarget() {
        return this.target;
    }

    @Override
    public double getMaxScore() {
        if (this.aligner != null) {
            this.align();
        }
        return this.max;
    }

    @Override
    public double getMinScore() {
        return 0.0;
    }

    @Override
    public double getScore() {
        if (this.aligner != null) {
            this.align();
        }
        return this.score;
    }

    private void align() {
        this.max = this.aligner.getPair().getLength();
        this.score = this.aligner.getPair().getNumIdenticals();
        this.aligner = null;
    }
}

