/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.routines;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.alignment.routines.AlignerHelper;
import org.biojava.nbio.alignment.template.AbstractPairwiseSequenceAligner;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.core.alignment.SimpleSequencePair;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class AnchoredPairwiseSequenceAligner<S extends Sequence<C>, C extends Compound>
extends AbstractPairwiseSequenceAligner<S, C> {
    public AnchoredPairwiseSequenceAligner() {
    }

    public AnchoredPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        this(query, target, gapPenalty, subMatrix, null);
    }

    public AnchoredPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, int[] anchors) {
        super(query, target, gapPenalty, subMatrix);
        this.setAnchors(anchors);
    }

    public int[] getAnchors() {
        int i;
        int[] anchor = new int[this.getScoreMatrixDimensions()[0] - 1];
        for (i = 0; i < anchor.length; ++i) {
            anchor[i] = -1;
        }
        for (i = 0; i < this.anchors.size(); ++i) {
            anchor[((AlignerHelper.Anchor)this.anchors.get((int)i)).getQueryIndex()] = ((AlignerHelper.Anchor)this.anchors.get(i)).getTargetIndex();
        }
        return anchor;
    }

    public void setAnchors(int[] anchors) {
        this.anchors = new ArrayList();
        if (anchors != null) {
            for (int i = 0; i < anchors.length; ++i) {
                if (anchors[i] < 0) continue;
                this.addAnchor(i, anchors[i]);
            }
        }
    }

    public void addAnchor(int queryIndex, int targetIndex) {
        this.anchors.add(new AlignerHelper.Anchor(queryIndex, targetIndex));
    }

    @Override
    protected void setProfile(List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        this.pair = new SimpleSequencePair(this.getQuery(), this.getTarget(), sx, sy);
        this.profile = this.pair;
    }
}

