/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DQuantPeptide;
import java.util.List;

class AggregatedQuantPeptide
extends DQuantPeptide {
    private final List<DQuantPeptide> m_quantPeptides;

    AggregatedQuantPeptide(List<DQuantPeptide> quantPeptides) {
        this.m_quantPeptides = quantPeptides;
    }

    public Float getRawAbundance() {
        if (this.m_quantPeptides != null) {
            return Float.valueOf((float)this.m_quantPeptides.stream().mapToDouble(qp -> qp.getRawAbundance().floatValue()).filter(d -> !Double.isNaN(d)).sum());
        }
        return null;
    }

    public Float getAbundance() {
        if (this.m_quantPeptides != null) {
            return Float.valueOf((float)this.m_quantPeptides.stream().mapToDouble(qp -> qp.getAbundance().floatValue()).filter(d -> !Double.isNaN(d)).sum());
        }
        return null;
    }

    public Integer getSelectionLevel() {
        return super.getSelectionLevel();
    }

    public Integer getPeptideMatchesCount() {
        if (this.m_quantPeptides != null) {
            return this.m_quantPeptides.stream().mapToInt(qp -> qp.getPeptideMatchesCount()).sum();
        }
        return null;
    }

    public Long getQuantChannelId() {
        return super.getQuantChannelId();
    }

    public Float getElutionTime() {
        return super.getElutionTime();
    }

    public Long getPeptideId() {
        return super.getPeptideId();
    }

    public Long getPeptideInstanceId() {
        return super.getPeptideInstanceId();
    }

    public Integer getIdentPeptideMatchCount() {
        if (this.m_quantPeptides != null) {
            return this.m_quantPeptides.stream().mapToInt(qp -> qp.getIdentPeptideMatchCount()).sum();
        }
        return null;
    }
}

