/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.gui;

import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerRoot;
import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.container.DockException;
import fr.proline.studio.dock.container.DockPosition;
import fr.proline.studio.dock.dragdrop.DockTransferable;
import fr.proline.studio.dock.dragdrop.DockingImportTransfertHandler;
import fr.proline.studio.dock.dragdrop.OverArea;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

public class DraggingOverlayPanel
extends JPanel {
    private final DockContainerRoot m_dockContainerRoot;
    private static final AlphaComposite ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
    private static final Color OVER_COLOR = new Color(51, 153, 255);
    private OverArea m_overArea = null;

    public DraggingOverlayPanel(DockContainerRoot dockContainerRoot) {
        this.m_dockContainerRoot = dockContainerRoot;
        this.setOpaque(false);
        DockingImportTransfertHandler transferHandler = new DockingImportTransfertHandler(this);
        this.setTransferHandler(transferHandler);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.m_overArea != null) {
            g2D.setColor(OVER_COLOR);
            Composite previousComposite = g2D.getComposite();
            g2D.setComposite(ALPHA_COMPOSITE);
            g2D.fill(this.m_overArea.getZone(this));
            g2D.setComposite(previousComposite);
        }
    }

    public OverArea getOverArea(Point pointOnScreen) {
        this.m_overArea = this.m_dockContainerRoot.getOverArea(pointOnScreen);
        this.repaint();
        return this.m_overArea;
    }

    public void resetOverArea() {
        this.m_overArea = null;
    }

    public void importData(DockTransferable dataSource) {
        if (this.m_overArea == null) {
            return;
        }
        DockContainerTab dockContainerTab = dataSource.getDockContainerTab();
        DockComponent dockComponent = dataSource.getDockComponent();
        dockContainerTab.remove(dockComponent);
        DockContainerTab destination = this.m_overArea.getDockContainerTab();
        DockPosition position = this.m_overArea.getPosition();
        try {
            destination.add((DockContainer)dockComponent, position);
        }
        catch (DockException dockException) {
            // empty catch block
        }
        dockContainerTab.removeIfEmpty();
    }
}

