/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.util.ArrayList;
import java.util.Map;

public class StatsModel
implements ExtendedTableModelInterface {
    private final ExtendedTableModelInterface m_src;
    private final int m_colSelected;
    private String m_modelName;

    public StatsModel(ExtendedTableModelInterface sourceDataInterface, int colSelected) {
        this.m_src = sourceDataInterface;
        this.m_colSelected = colSelected;
    }

    @Override
    public int getRowCount() {
        return this.m_src.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_src.getDataColumnIdentifier(this.m_colSelected);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.m_src.getDataColumnClass(this.m_colSelected);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.m_src.getDataValueAt(rowIndex, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return null;
    }

    @Override
    public void setName(String name) {
        this.m_modelName = name;
    }

    @Override
    public String getName() {
        return this.m_modelName;
    }

    public double getValue(int rowIndex) {
        Object value = this.getDataValueAt(rowIndex, this.m_colSelected);
        return value == null ? Double.NaN : ((Number)value).doubleValue();
    }

    public double sumNaN() {
        double s = 0.0;
        int nb = this.getRowCount();
        for (int i = 0; i < nb; ++i) {
            double d = this.getValue(i);
            if (d != d) continue;
            s += d;
        }
        return s;
    }

    public double meanNaN() {
        int nb = this.getRowCount();
        int countWithoutNaN = 0;
        for (int i = 0; i < nb; ++i) {
            double d = this.getValue(i);
            if (d != d) continue;
            ++countWithoutNaN;
        }
        return this.sumNaN() / (double)countWithoutNaN;
    }

    public double varianceNaN() {
        double v = 0.0;
        double mean = this.meanNaN();
        int nb = this.getRowCount();
        for (int i = 0; i < nb; ++i) {
            double d = this.getValue(i);
            if (d != d) continue;
            double diff = d - mean;
            v += diff * diff;
        }
        return v / (double)nb;
    }

    public double standardDeviationNaN() {
        return Math.sqrt(this.varianceNaN());
    }

    @Override
    public int getInfoColumn() {
        return this.m_src.getInfoColumn();
    }

    @Override
    public Map<String, Object> getExternalData() {
        return this.m_src.getExternalData();
    }

    @Override
    public PlotInformation getPlotInformation() {
        return this.m_src.getPlotInformation();
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return this.m_src.row2UniqueId(rowIndex);
    }

    @Override
    public int uniqueId2Row(long id) {
        return this.m_src.uniqueId2Row(id);
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_src.getExtraDataTypes();
    }

    @Override
    public Object getValue(Class c) {
        return this.m_src.getValue(c);
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return this.m_src.getRowValue(c, row);
    }

    @Override
    public Object getColValue(Class c, int col) {
        return this.m_src.getColValue(c, col);
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public Object getSingleValue(Class c) {
        return this.m_src.getSingleValue(c);
    }

    @Override
    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

