/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.AxisTicks;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;

public class XAxis
extends Axis {
    private static final double FONT_ROTATE = 0.5235987755982988;
    private int m_lastWidth;
    private AxisTicks m_ticks;

    public XAxis(BasePlotPanel p) {
        super(p);
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.m_selected) {
            int stringWidth = this.m_valuesFontMetrics.stringWidth("    ");
            g.setColor(Color.darkGray);
            g.fillRect(this.m_x - stringWidth, this.m_y, this.m_width + stringWidth * 2, this.m_height);
        }
        if (this.m_selected) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        if (this.m_log) {
            this.paintLog(g, this.m_ticks);
        } else {
            this.paintLinear(g, this.m_ticks);
        }
        if (this.m_title != null && this.m_displayTitle) {
            if (this.m_titleFont == null) {
                this.m_titleFont = g.getFont().deriveFont(1, 11.0f);
                this.m_titleFontMetrics = g.getFontMetrics(this.m_titleFont);
            }
            g.setFont(this.m_titleFont);
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            int titleWidth = this.m_titleFontMetrics.stringWidth(this.m_title);
            int bottom = this.m_y + this.m_height;
            int top = this.m_y + this.m_height - 20 - 5;
            int ascent = this.m_titleFontMetrics.getAscent();
            int descent = this.m_titleFontMetrics.getDescent();
            int baseline = top + (bottom + 1 - top) / 2 - (ascent + descent) / 2 + ascent;
            g.drawString(this.m_title, this.m_x + (this.m_width - titleWidth) / 2, baseline);
        }
    }

    @Override
    public void paintCursor(Graphics2D g, AbstractCursor cursor, boolean selected) {
        String label;
        int fractionalDigits;
        g.setFont(this.m_valuesFont);
        int DELTA = 3;
        double x = cursor.getValue();
        int integerDigits = cursor.getIntegerDigits();
        if (integerDigits == -1) {
            integerDigits = this.m_ticks.getIntegerDigits();
        }
        if ((fractionalDigits = cursor.getFractionalDigits()) == -1) {
            fractionalDigits = this.m_ticks.getFractionalDigits() + 2;
        }
        double multForRounding = Math.pow(10.0, fractionalDigits);
        if (this.m_isEnum) {
            label = this.m_plotPanel.getEnumValueX((int)Math.round(x), false);
            if (label == null) {
                label = " ";
            }
        } else {
            double xDisplay;
            double d = xDisplay = this.m_log ? StrictMath.log10(x) : x;
            if (fractionalDigits > 0) {
                xDisplay = (double)StrictMath.round(xDisplay * multForRounding) / multForRounding;
            }
            DecimalFormat df = this.selectDecimalFormat(fractionalDigits + 2, integerDigits);
            label = df.format(xDisplay);
            cursor.setFormat(integerDigits, fractionalDigits, df);
        }
        int stringWidth = this.m_valuesFontMetrics.stringWidth(label);
        int posX = this.valueToPixel(x);
        int height = this.m_valuesFontMetrics.getHeight();
        Stroke prevStroke = g.getStroke();
        g.setStroke(selected ? AbstractCursor.LINE2_STROKE : cursor.getStroke());
        g.setColor(Color.white);
        int rightLimitX = this.valueToPixel(this.m_maxValue);
        int flagPositionX = posX + stringWidth + 6;
        if (flagPositionX < rightLimitX) {
            g.fillRect(posX, this.m_y + 4 + 5 - 3, stringWidth + 6, height + 6);
            g.setColor(cursor.getColor());
            g.drawLine(posX, this.m_y, posX, this.m_y + 4 + 5 - 3);
            g.drawRect(posX, this.m_y + 4 + 5 - 3, stringWidth + 6, height + 6);
            g.drawString(label, posX + 3, this.m_y + height + 4 + 5);
        } else {
            g.fillRect(posX - (stringWidth + 6), this.m_y + 4 + 5 - 3, stringWidth + 6, height + 6);
            g.setColor(cursor.getColor());
            g.drawLine(posX, this.m_y, posX, this.m_y + 4 + 5 - 3);
            g.drawRect(posX - (stringWidth + 6), this.m_y + 4 + 5 - 3, stringWidth + 6, height + 6);
            g.drawString(label, posX - stringWidth - 3, this.m_y + height + 4 + 5);
        }
        g.setStroke(prevStroke);
    }

    public String defaultFormat(double x) {
        String label;
        int integerDigits = this.m_ticks.getIntegerDigits();
        int fractionalDigits = this.m_ticks.getFractionalDigits() + 2;
        double multForRounding = Math.pow(10.0, fractionalDigits);
        if (this.m_isEnum) {
            label = this.m_plotPanel.getEnumValueX((int)Math.round(x), false);
            if (label == null) {
                label = " ";
            }
        } else {
            double xDisplay;
            double d = xDisplay = this.m_log ? StrictMath.log10(x) : x;
            if (fractionalDigits > 0) {
                xDisplay = (double)StrictMath.round(xDisplay * multForRounding) / multForRounding;
            }
            DecimalFormat df = this.selectDecimalFormat(fractionalDigits + 2, integerDigits);
            label = df.format(xDisplay);
        }
        return label;
    }

    public void preparePaint(Graphics2D g) {
        this.m_labelMaxWidth = 0;
        this.m_mustDrawDiagonalLabels = false;
        if (this.m_valuesFont == null) {
            this.m_valuesFont = g.getFont().deriveFont(0, 10.0f);
            this.m_valuesFontMetrics = g.getFontMetrics(this.m_valuesFont);
        }
        int maxTicks = this.m_width / 30;
        this.m_ticks = new AxisTicks(this.m_minValue, this.m_maxValue, maxTicks, this.m_log, 1.0E-12, this.m_isInteger, this.m_isEnum);
        this.m_minTick = this.m_ticks.getTickMin();
        this.m_maxTick = this.m_ticks.getTickMax();
        this.m_tickSpacing = this.m_ticks.getTickSpacing();
        if (this.m_log) {
            this.preparePaintLog(g, this.m_ticks);
        } else {
            this.preparePaintLinear(g, this.m_ticks);
        }
        if (this.m_mustDrawDiagonalLabels) {
            this.m_labelMinWidth = this.m_valuesFontMetrics.stringWidth("000");
            if (this.m_valuesDiagonalFont == null) {
                AffineTransform rotateText = new AffineTransform();
                rotateText.rotate(0.5235987755982988);
                this.m_valuesDiagonalFont = this.m_valuesFont.deriveFont(rotateText);
            }
            this.m_minimumAxisHeight = 8 + this.m_valuesFontMetrics.getHeight() + (int)Math.round(StrictMath.ceil(StrictMath.sin(0.5235987755982988) * (double)this.m_labelMaxWidth));
        } else {
            this.m_labelMinWidth = this.m_valuesFontMetrics.stringWidth("0");
            this.m_minimumAxisHeight = 8 + this.m_valuesFontMetrics.getHeight();
        }
    }

    private void preparePaintLinear(Graphics2D g, AxisTicks ticks) {
        int pixelStop;
        int pixelStart;
        int fractionalDigits = ticks.getFractionalDigits();
        int integerDigits = ticks.getIntegerDigits();
        if (fractionalDigits != this.m_fractionalDigits || integerDigits != this.m_integerDigits || this.m_df == null) {
            this.m_df = this.selectDecimalFormat(fractionalDigits, integerDigits);
            this.m_dfPlot = this.selectDecimalFormat(fractionalDigits + 2, integerDigits);
            this.m_fractionalDigits = fractionalDigits;
            this.m_integerDigits = integerDigits;
        }
        if ((pixelStart = this.valueToPixel(this.m_minTick)) >= (pixelStop = this.valueToPixel(this.m_maxTick))) {
            return;
        }
        double multForRounding = Math.pow(10.0, fractionalDigits);
        String maxLabel = "";
        double x = this.m_minTick;
        int pX = pixelStart;
        int previousEndX = -2147483647;
        do {
            int posX;
            int stringWidth;
            String label;
            if (this.m_isEnum) {
                label = this.m_plotPanel.getEnumValueX((int)Math.round(x), false);
                if (label == null || label.isEmpty()) {
                    label = " ";
                }
                stringWidth = this.m_valuesFontMetrics.stringWidth(label);
            } else {
                double xDisplay = x;
                if (fractionalDigits > 0) {
                    xDisplay = (double)StrictMath.round(xDisplay * multForRounding) / multForRounding;
                }
                label = this.m_df.format(xDisplay);
                stringWidth = this.m_valuesFontMetrics.stringWidth(label);
            }
            if (stringWidth > this.m_labelMaxWidth) {
                this.m_labelMaxWidth = stringWidth;
                maxLabel = label;
            }
            if ((posX = pX - stringWidth / 2) > previousEndX + 2) {
                previousEndX = posX + stringWidth;
                continue;
            }
            this.m_mustDrawDiagonalLabels = true;
            previousEndX = posX + this.m_valuesFontMetrics.stringWidth("000");
        } while ((pX = this.valueToPixel(x += this.m_tickSpacing)) <= pixelStop);
        if (this.m_mustDrawDiagonalLabels && maxLabel.length() > 20) {
            maxLabel = maxLabel.substring(0, 19) + "..";
            this.m_labelMaxWidth = this.m_valuesFontMetrics.stringWidth(maxLabel);
        }
    }

    private void preparePaintLog(Graphics2D g, AxisTicks ticks) {
        int pixelStop;
        int pixelStart;
        if (this.m_df == null) {
            this.m_df = this.selectLogDecimalFormat();
            this.m_dfPlot = this.selectLogDecimalFormat();
        }
        if ((pixelStart = this.valueToPixel(Math.pow(10.0, this.m_minTick))) >= (pixelStop = this.valueToPixel(Math.pow(10.0, this.m_maxTick)))) {
            return;
        }
        double x = this.m_minTick;
        int pX = pixelStart;
        int previousEndX = -2147483647;
        do {
            int posX;
            double xDisplay;
            String s;
            int stringWidth;
            if ((stringWidth = this.m_valuesFontMetrics.stringWidth(s = this.m_df.format(xDisplay = x))) > this.m_labelMaxWidth) {
                this.m_labelMaxWidth = stringWidth;
            }
            if ((posX = pX - stringWidth / 2) > previousEndX + 2) {
                previousEndX = posX + stringWidth;
                continue;
            }
            this.m_mustDrawDiagonalLabels = true;
            previousEndX = posX + this.m_valuesFontMetrics.stringWidth("000");
        } while ((pX = this.valueToPixel(Math.pow(10.0, x += this.m_tickSpacing))) <= pixelStop);
    }

    private void paintLinear(Graphics2D g, AxisTicks ticks) {
        int pixelStart = this.valueToPixel(this.m_minValue);
        int pixelStop = this.valueToPixel(this.m_maxValue);
        g.drawLine(pixelStart, this.m_y + 5, pixelStop, this.m_y + 5);
        if (pixelStart >= pixelStop) {
            return;
        }
        if (this.m_selected) {
            g.setColor(Color.white);
        } else {
            g.setColor(CyclicColorPalette.GRAY_TEXT_DARK);
        }
        g.setFont(this.m_mustDrawDiagonalLabels ? this.m_valuesDiagonalFont : this.m_valuesFont);
        int height = this.m_valuesFontMetrics.getHeight();
        int fractionalDigits = ticks.getFractionalDigits();
        double multForRounding = Math.pow(10.0, fractionalDigits);
        double x = this.m_minTick;
        if (this.valueToPixel(x) < pixelStart) {
            x += this.m_tickSpacing;
        }
        int pX = this.valueToPixel(x);
        int previousEndX = -2147483647;
        this.m_lastWidth = -1;
        do {
            int posX;
            String label;
            if (this.m_isEnum) {
                label = this.m_plotPanel.getEnumValueX((int)Math.round(x), false);
                if (label == null) {
                    label = " ";
                }
                if (this.m_mustDrawDiagonalLabels && label.length() > 20) {
                    label = label.substring(0, 19) + "..";
                }
            } else {
                double xDisplay = x;
                if (fractionalDigits > 0) {
                    xDisplay = (double)StrictMath.round(xDisplay * multForRounding) / multForRounding;
                }
                label = this.m_df.format(xDisplay);
            }
            if (this.m_mustDrawDiagonalLabels) {
                posX = pX;
            } else {
                int stringWidth = this.m_valuesFontMetrics.stringWidth(label);
                posX = pX - stringWidth / 2;
            }
            if (posX <= previousEndX + 2) continue;
            g.drawLine(pX, this.m_y + 5, pX, this.m_y + 4 + 5);
            g.drawString(label, posX, this.m_y + height + 4 + 5);
            previousEndX = posX + this.m_labelMinWidth;
        } while ((pX = this.valueToPixel(x += this.m_tickSpacing)) <= pixelStop);
        g.setFont(this.m_valuesFont);
    }

    private void paintLog(Graphics2D g, AxisTicks ticks) {
        this.m_minTick = ticks.getTickMin();
        this.m_maxTick = ticks.getTickMax();
        this.m_tickSpacing = ticks.getTickSpacing();
        if (this.m_df == null) {
            this.m_df = this.selectLogDecimalFormat();
            this.m_dfPlot = this.selectLogDecimalFormat();
        }
        int pixelStart = this.valueToPixel(this.m_minValue);
        int pixelStop = this.valueToPixel(this.m_maxValue);
        g.drawLine(pixelStart, this.m_y + 5, pixelStop, this.m_y + 5);
        if (pixelStart >= pixelStop) {
            return;
        }
        g.setFont(this.m_mustDrawDiagonalLabels ? this.m_valuesDiagonalFont : this.m_valuesFont);
        int height = this.m_valuesFontMetrics.getHeight();
        double x = this.m_minTick;
        int pX = pixelStart;
        int previousEndX = -2147483647;
        do {
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(CyclicColorPalette.GRAY_TEXT_DARK);
            }
            g.drawLine(pX, this.m_y + 5, pX, this.m_y + 4 + 5);
            double xDisplay = x;
            String s = this.m_df.format(xDisplay);
            int stringWidth = this.m_valuesFontMetrics.stringWidth(s);
            int posX = pX - stringWidth / 2;
            int delta = pX - this.valueToPixel(Math.pow(10.0, x));
            if (posX > previousEndX + 2 && delta == 0) {
                g.drawString(s, posX, this.m_y + height + 4 + 5);
                previousEndX = posX + stringWidth;
            }
            pX = this.valueToPixel(Math.pow(10.0, x += this.m_tickSpacing));
            if (this.m_selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(CyclicColorPalette.GRAY_TEXT_LIGHT);
            }
            for (int i = 2; i <= 9; ++i) {
                double xMinTick = Math.pow(10.0, x) * ((double)i * 0.1);
                int pMinTick = this.valueToPixel(xMinTick);
                if (pMinTick > pixelStop || pMinTick < pixelStart) continue;
                g.drawLine(pMinTick, this.m_y + 5, pMinTick, this.m_y + 4 + 5);
            }
        } while (pX <= pixelStop);
    }

    public void paintGrid(Graphics2D g, int x, int width, int y, int height) {
        if (this.m_log) {
            this.paintGridLog(g, y, height);
        } else {
            this.paintGridLinear(g, x, width, y, height);
        }
    }

    public void paintGridLinear(Graphics2D g, int xPixel, int width, int yPixel, int height) {
        int pixelStart = this.valueToPixel(this.m_minTick);
        int pixelStop = this.valueToPixel(this.m_maxTick);
        int stop = this.m_x + (int)Math.round((this.m_maxTick - this.m_minValue) / (this.m_maxValue - this.m_minValue) * (double)this.m_width);
        if (pixelStart >= pixelStop) {
            return;
        }
        g.setColor(CyclicColorPalette.GRAY_GRID);
        Stroke s = g.getStroke();
        g.setStroke(DASHED);
        double x = this.m_minTick;
        int pX = pixelStart;
        int previousEndX = -2147483647;
        do {
            if (pX <= previousEndX + 2) continue;
            if (pX >= xPixel && pX <= xPixel + width) {
                g.drawLine(pX, yPixel, pX, yPixel + height - 1);
            }
            previousEndX = pX + this.m_lastWidth;
        } while ((pX = this.valueToPixel(x += this.m_tickSpacing)) <= pixelStop);
        g.setStroke(s);
    }

    public void paintGridLog(Graphics2D g, int y, int height) {
        int pixelStop;
        int pixelStart = this.valueToPixel(Math.pow(10.0, this.m_minTick));
        if (pixelStart >= (pixelStop = this.valueToPixel(Math.pow(10.0, this.m_maxTick)))) {
            return;
        }
        Stroke s = g.getStroke();
        g.setStroke(DASHED);
        double x = this.m_minTick;
        int pX = pixelStart;
        block0: while (true) {
            g.setColor(CyclicColorPalette.GRAY_GRID);
            g.drawLine(pX, y, pX, y + height - 1);
            pX = this.valueToPixel(Math.pow(10.0, x += this.m_tickSpacing));
            if (pX > pixelStop) break;
            g.setColor(CyclicColorPalette.GRAY_GRID_LOG);
            int i = 2;
            while (true) {
                if (i > 9) continue block0;
                double xMinTick = Math.pow(10.0, x) * ((double)i * 0.1);
                int pMinTick = this.valueToPixel(xMinTick);
                g.drawLine(pMinTick, y, pMinTick, y + height - 1);
                ++i;
            }
            break;
        }
        g.setStroke(s);
    }

    @Override
    public int valueToPixel(double v) {
        if (this.m_isPixel) {
            return (int)Math.round(v);
        }
        double d = v = Double.valueOf(v).isNaN() ? 0.0 : v;
        if (this.m_log) {
            double logV = v <= 1.0E-12 || Double.isNaN(v) ? Math.log10(1.0E-12) : Math.log10(v);
            double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
            double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
            return this.m_x + (int)Math.round((logV - min) / (max - min) * (double)this.m_width);
        }
        return this.m_x + (int)Math.round((v - this.m_minValue) / (this.m_maxValue - this.m_minValue) * (double)this.m_width);
    }

    @Override
    public double pixelToValue(int pixel) {
        if (this.m_isPixel) {
            return pixel;
        }
        if (this.m_log) {
            double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
            double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
            double v = min + ((double)pixel - (double)this.m_x) / (double)this.m_width * (max - min);
            v = Math.pow(10.0, v);
            return v;
        }
        double v = this.m_minValue + ((double)pixel - (double)this.m_x) / (double)this.m_width * (this.m_maxValue - this.m_minValue);
        return v;
    }

    @Override
    public double deltaPixelToDeltaValue(int deltaPixel) {
        double value1 = this.pixelToValue(this.m_width / 2);
        double value2 = this.pixelToValue(this.m_width / 2 + deltaPixel);
        return value2 - value1;
    }

    @Override
    public double deltaPixelToLogMultValue(int deltaPixel) {
        double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
        double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
        double mult = Math.pow(10.0, (max - min) * ((double)deltaPixel / (double)this.m_width));
        if (Math.pow(10.0, min) / mult < 1.0E-12) {
            mult = Math.pow(10.0, min) / 1.0E-12;
        }
        return mult;
    }
}

