/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.graphics.ColorButton;
import fr.proline.studio.graphics.ColorButtonAndPalettePanel;
import fr.proline.studio.graphics.colorpicker.ColorDataInterface;
import fr.proline.studio.graphics.colorpicker.ColorPickerPanel;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;

public class ColorParameter
extends AbstractParameter {
    private Color m_defaultColor = null;
    private boolean m_edited = false;
    private Color m_startValue;

    public ColorParameter(String key, String name, Color defaultColor) {
        super(key, name, Color.class, ColorButton.class);
        this.m_defaultColor = defaultColor;
    }

    public ColorParameter(String key, String name, Color defaultColor, Class graphicalType) {
        super(key, name, Color.class, graphicalType);
        this.m_defaultColor = defaultColor;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = (Color)value;
        if (this.m_startValue == null) {
            this.m_startValue = this.m_defaultColor;
        }
        if (this.m_parameterComponent != null) {
            if (this.m_graphicalType.equals(ColorButton.class)) {
                ((ColorButton)this.m_parameterComponent).setColor(this.m_startValue);
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(ColorPickerPanel.class)) {
                ((ColorPickerPanel)this.m_parameterComponent).setColor(this.m_startValue);
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(ColorButtonAndPalettePanel.class)) {
                ((ColorButtonAndPalettePanel)this.m_parameterComponent).setColor(this.m_startValue);
                return this.m_parameterComponent;
            }
        }
        if (this.m_graphicalType.equals(ColorButton.class)) {
            final ColorButton colorButton = new ColorButton();
            colorButton.initActionListener();
            colorButton.setColor(this.m_startValue);
            colorButton.addListener(new ColorDataInterface(){

                @Override
                public void propagateColorChanged(int r, int g, int b) {
                    if (ColorParameter.this.m_externalActionListener != null) {
                        ActionEvent e = new ActionEvent(colorButton, -1, null);
                        ColorParameter.this.m_externalActionListener.actionPerformed(e);
                    }
                }

                @Override
                public int getRed() {
                    return -1;
                }

                @Override
                public int getGreen() {
                    return -1;
                }

                @Override
                public int getBlue() {
                    return -1;
                }

                @Override
                public void addListener(ColorDataInterface colorDataInterface) {
                }
            });
            this.m_parameterComponent = colorButton;
            return colorButton;
        }
        if (this.m_graphicalType.equals(ColorPickerPanel.class)) {
            ColorPickerPanel colorPanel = new ColorPickerPanel(CyclicColorPalette.getPalette());
            colorPanel.setColor(this.m_startValue);
            this.m_parameterComponent = colorPanel;
            return colorPanel;
        }
        if (this.m_graphicalType.equals(ColorButtonAndPalettePanel.class)) {
            ColorButtonAndPalettePanel colorButtonPalettePanel = new ColorButtonAndPalettePanel();
            colorButtonPalettePanel.setColor(this.m_startValue);
            this.m_parameterComponent = colorButtonPalettePanel;
            return colorButtonPalettePanel;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultColor == null) {
            return;
        }
        if (this.m_graphicalType.equals(ColorButton.class)) {
            ColorButton colorButton = (ColorButton)this.m_parameterComponent;
            colorButton.setColor(this.m_defaultColor);
        } else if (this.m_graphicalType.equals(ColorPickerPanel.class)) {
            ColorPickerPanel colorPanel = (ColorPickerPanel)this.m_parameterComponent;
            colorPanel.setColor(this.m_defaultColor);
        } else if (this.m_graphicalType.equals(ColorButtonAndPalettePanel.class)) {
            ColorButtonAndPalettePanel panel = (ColorButtonAndPalettePanel)this.m_parameterComponent;
            panel.setColor(this.m_defaultColor);
        }
    }

    @Override
    public ParameterError checkParameter() {
        return null;
    }

    @Override
    public String getStringValue() {
        Object v = this.getObjectValue();
        return v != null ? v.toString() : null;
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(ColorButton.class) && this.m_parameterComponent != null) {
            return ((ColorButton)this.m_parameterComponent).getColor();
        }
        if (this.m_graphicalType.equals(ColorPickerPanel.class) && this.m_parameterComponent != null) {
            return ((ColorPickerPanel)this.m_parameterComponent).getColor();
        }
        if (this.m_graphicalType.equals(ColorButtonAndPalettePanel.class) && this.m_parameterComponent != null) {
            return ((ColorButtonAndPalettePanel)this.m_parameterComponent).getColor();
        }
        return null;
    }

    public Color getColor() {
        Color c = (Color)this.getObjectValue();
        if (c == null) {
            return this.m_defaultColor;
        }
        return c;
    }

    public void setColor(Color c) {
        if (c == null) {
            c = this.m_defaultColor;
        }
        if (this.m_graphicalType.equals(ColorButton.class) && this.m_parameterComponent != null) {
            ((ColorButton)this.m_parameterComponent).setColor(c);
        } else if (this.m_graphicalType.equals(ColorPickerPanel.class) && this.m_parameterComponent != null) {
            ((ColorPickerPanel)this.m_parameterComponent).setColor(c);
        } else if (this.m_graphicalType.equals(ColorButtonAndPalettePanel.class) && this.m_parameterComponent != null) {
            ((ColorButtonAndPalettePanel)this.m_parameterComponent).setColor(c);
        }
        if (c != null && this.m_startValue != null) {
            this.m_edited = c != this.m_startValue;
        }
    }

    @Override
    public void setValue(String v) {
        if (this.m_parameterComponent == null) {
            return;
        }
        if (this.m_graphicalType.equals(ColorButton.class) || this.m_graphicalType.equals(ColorPickerPanel.class) || this.m_graphicalType.equals(ColorButtonAndPalettePanel.class)) {
            // empty if block
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

