/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.settings;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.settings.SettingsUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SettingsDialog
extends DefaultDialog {
    private static final String DEFAULT_SETTINGS = "Default Settings";
    private JTextField m_fileTextField;
    private JList<String> m_filesList;
    private JButton m_openButton;
    private boolean m_defaultSettings = false;
    private File m_selectedFile = null;
    private JFileChooser m_fileChooser = null;
    private String m_chooserDefaultDirectory = null;
    private ArrayList<String> m_potentialSettingsFile = null;
    private String m_settingsKey = null;

    public SettingsDialog(Window parent, String settingsKey) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_settingsKey = settingsKey;
        this.setTitle("Settings");
        this.setButtonVisible(5, false);
        this.m_chooserDefaultDirectory = SettingsUtils.readDefaultDirectory(settingsKey);
        this.m_potentialSettingsFile = SettingsUtils.readSettingsPaths(settingsKey);
        this.setInternalComponent(this.createInternalPanel(this.m_potentialSettingsFile));
    }

    private JPanel createInternalPanel(ArrayList<String> potentialSettingsFile) {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.setBorder(BorderFactory.createTitledBorder(" Settings File Selection "));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_openButton = new JButton(IconManager.getIcon(IconManager.IconType.OPEN_FILE));
        this.m_fileTextField = new JTextField(30);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        listModel.addElement(DEFAULT_SETTINGS);
        for (int i = 0; i < potentialSettingsFile.size(); ++i) {
            listModel.addElement(potentialSettingsFile.get(i));
        }
        this.m_filesList = new JList(listModel);
        JScrollPane filesListScrollPane = new JScrollPane(this.m_filesList){
            private final Dimension preferredSize;
            {
                this.preferredSize = new Dimension(280, 140);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                if (SettingsDialog.this.m_fileChooser == null) {
                    SettingsDialog.this.m_fileChooser = new JFileChooser(SettingsDialog.this.m_chooserDefaultDirectory);
                    SettingsDialog.this.m_fileChooser.setMultiSelectionEnabled(false);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Proline Settings File", "settings");
                    SettingsDialog.this.m_fileChooser.addChoosableFileFilter(filter);
                    SettingsDialog.this.m_fileChooser.setFileFilter(filter);
                }
                if ((result = SettingsDialog.this.m_fileChooser.showOpenDialog(SettingsDialog.this.m_openButton)) == 0) {
                    SettingsDialog.this.m_fileTextField.setText(SettingsDialog.this.m_fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.m_filesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String value = (String)SettingsDialog.this.m_filesList.getSelectedValue();
                if (value != null) {
                    SettingsDialog.this.m_fileTextField.setText((String)SettingsDialog.this.m_filesList.getSelectedValue());
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        internalPanel.add((Component)this.m_fileTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        internalPanel.add((Component)this.m_openButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        internalPanel.add((Component)filesListScrollPane, c);
        return internalPanel;
    }

    @Override
    protected boolean okCalled() {
        String filePath = this.m_fileTextField.getText().trim();
        if (filePath.isEmpty()) {
            this.setStatus(true, "You must choose a Settings File");
            this.highlight(this.m_fileTextField);
            return false;
        }
        if (filePath.compareToIgnoreCase(DEFAULT_SETTINGS) == 0) {
            this.m_defaultSettings = true;
            return true;
        }
        File f = new File(filePath);
        if (!f.exists()) {
            this.setStatus(true, "This file does not exist");
            this.highlight(this.m_fileTextField);
            return false;
        }
        if (f.isDirectory()) {
            this.setStatus(true, "You must select a File, not a Directory");
            this.highlight(this.m_fileTextField);
            return false;
        }
        if (!f.canRead()) {
            this.setStatus(true, "The file is not readable");
            this.highlight(this.m_fileTextField);
            return false;
        }
        this.m_selectedFile = f;
        String path = f.getAbsolutePath();
        boolean pathFound = false;
        for (int i = 0; i < this.m_potentialSettingsFile.size(); ++i) {
            String pathCur = this.m_potentialSettingsFile.get(i);
            if (pathCur.compareTo(path) != 0) continue;
            pathFound = true;
            break;
        }
        if (!pathFound) {
            this.m_potentialSettingsFile.add(0, f.getAbsolutePath());
        }
        SettingsUtils.writeSettingsPath(this.m_settingsKey, this.m_potentialSettingsFile);
        SettingsUtils.writeDefaultDirectory(this.m_settingsKey, f.getParent());
        return true;
    }

    @Override
    protected boolean cancelCalled() {
        return true;
    }

    public boolean isDefaultSettingsSelected() {
        return this.m_defaultSettings;
    }

    public File getSelectedFile() {
        return this.m_selectedFile;
    }
}

